package io.dddrive.core.ddd.model;

import java.util.List;

public interface AggregatePersistenceProvider<A extends Aggregate> {

	/**
	 * The repository.
	 *
	 * @return the repository
	 */
	AggregateRepository<A> getRepository();

	/**
	 * Convert id to string
	 */
	String idToString(Object id);

	/**
	 * Convert string to id
	 */
	Object idFromString(String id);

	/**
	 * Generate new aggregate id.
	 *
	 * @return new aggregate id
	 */
	Object nextAggregateId();

	/**
	 * Generate new part id.
	 *
	 * @return new part id
	 */
	<P extends Part<A>> Integer nextPartId(Class<P> partClass);

	/**
	 * Load the aggregate from persistence store.
	 * Actual storage strategy depends on persistence provider.
	 *
	 * @param aggregate newly created, yet empty aggregate
	 * @param id        aggregate id
	 */
	void doLoad(A aggregate, Object id);

	/**
	 * Store the aggregate on the persistence layer.
	 *
	 * @param aggregate aggregate to store
	 */
	void doStore(A aggregate);

	/**
	 * Get all aggregates.
	 *
	 * @return all aggregates
	 */
	List<A> getAll();

	/**
	 * Get a list of Aggregates with the given foreign key pointing to targetId
	 */
	List<A> getByForeignKey(String fkName, Object targetId);

}
