package io.dddrive.core.ddd.model;

import io.dddrive.core.oe.model.ObjTenant;
import io.dddrive.core.oe.model.ObjUser;

/**
 * A DDD Aggregate Root.
 */
public interface Aggregate {

	Object getId();

	Object getTenantId();

	ObjTenant getTenant();

	ObjUser getOwner();

	void setOwner(ObjUser owner);

	String getCaption();

	AggregateMeta getMeta();

	/**
	 * Calculate all the derived fields, typically after a field change.
	 */
	void calcAll();

	/**
	 * Calculate all the volatile derived fields, i.e. fields that are not saved to
	 * the database. This is triggered after loading the aggregate from the
	 * database.
	 */
	void calcVolatile();

}
