
package io.dddrive.validation.model.enums;

import io.dddrive.app.service.api.AppContextSPI;
import io.dddrive.enums.model.base.EnumerationBase;

public class CodeValidationLevelEnum extends EnumerationBase<CodeValidationLevel> {

	public static CodeValidationLevel INFO;
	public static CodeValidationLevel WARNING;
	public static CodeValidationLevel ERROR;

	private static CodeValidationLevelEnum INSTANCE;

	public CodeValidationLevelEnum(AppContextSPI appContext) {
		super(CodeValidationLevel.class, appContext);
		INSTANCE = this;
		INFO = new CodeValidationLevel(this, "info", "Info");
		WARNING = new CodeValidationLevel(this, "warning", "Warning");
		ERROR = new CodeValidationLevel(this, "error", "Error");
		this.addItem(INFO);
		this.addItem(WARNING);
		this.addItem(ERROR);
	}

	public static CodeValidationLevel getValidationLevel(String validationLevelId) {
		return INSTANCE.getItem(validationLevelId);
	}

}
