package io.dddrive.validation.adapter.api.jsonapi.dto;

import io.dddrive.enums.adapter.api.jsonapi.dto.EnumeratedDto;
import io.dddrive.validation.model.AggregatePartValidation;

public class AggregatePartValidationDto {

	private final Integer seqNr;
	private final EnumeratedDto validationLevel;
	private final String validation;

	public AggregatePartValidationDto(Integer seqNr, EnumeratedDto validationLevel, String validation) {
		this.seqNr = seqNr;
		this.validationLevel = validationLevel;
		this.validation = validation;
	}

	public Integer getSeqNr() {
		return this.seqNr;
	}

	public EnumeratedDto getValidationLevel() {
		return this.validationLevel;
	}

	public String getValidation() {
		return this.validation;
	}

	public static AggregatePartValidationDto fromValidation(AggregatePartValidation validation) {
		return new AggregatePartValidationDto(
				validation.getSeqNr(),
				EnumeratedDto.fromEnum(validation.getValidationLevel()),
				validation.getValidation());
	}

}
