
package io.dddrive.search.model;

import java.math.BigDecimal;

import io.dddrive.ddd.model.enums.CodeAggregateType;

public class SearchResult implements Comparable<SearchResult> {

	private Integer tenantId;
	private CodeAggregateType aggregateType;
	private Integer id;
	private String caption;
	private BigDecimal rank;

	public SearchResult(Integer tenantId, CodeAggregateType aggregateType, Integer id, String caption, BigDecimal rank) {
		this.tenantId = tenantId;
		this.aggregateType = aggregateType;
		this.id = id;
		this.caption = caption;
		this.rank = rank;
	}

	public Integer getTenantId() {
		return this.tenantId;
	}

	public CodeAggregateType getAggregateType() {
		return this.aggregateType;
	}

	public Integer getId() {
		return this.id;
	}

	public String getCaption() {
		return this.caption;
	}

	public BigDecimal getRank() {
		return this.rank;
	}

	@Override
	public int compareTo(SearchResult other) {
		return this.rank.compareTo(other.getRank());
	}

}
