
package io.dddrive.obj.model.base;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Autowired;

import io.dddrive.ddd.model.AggregateRepository;
import io.dddrive.ddd.model.base.AggregateRepositoryBase;
import io.dddrive.obj.model.Obj;
import io.dddrive.obj.model.ObjPartItemRepository;
import io.dddrive.obj.model.ObjPartTransitionRepository;
import io.dddrive.obj.model.ObjRepository;

public abstract class ObjRepositoryBase<O extends Obj, V extends Object>
		extends AggregateRepositoryBase<O, V>
		implements ObjRepository<O, V> {

	private ObjPartTransitionRepository transitionRepository;
	private ObjPartItemRepository itemRepository;

	protected ObjRepositoryBase(
			Class<? extends AggregateRepository<O, V>> repoIntfClass,
			Class<? extends Obj> intfClass,
			Class<? extends Obj> baseClass,
			String aggregateTypeId) {
		super(repoIntfClass, intfClass, baseClass, aggregateTypeId);
	}

	@Autowired
	void setTransitionRepository(ObjPartTransitionRepository transitionRepository) {
		this.transitionRepository = transitionRepository;
	}

	@Override
	public ObjPartTransitionRepository getTransitionRepository() {
		return this.transitionRepository;
	}

	@Autowired
	void setItemRepository(ObjPartItemRepository itemRepository) {
		this.itemRepository = itemRepository;
	}

	@Override
	public ObjPartItemRepository getItemRepository() {
		return this.itemRepository;
	}

	@Override
	@PostConstruct
	public void registerPartRepositories() {
		this.addPartRepository(this.transitionRepository);
		this.addPartRepository(this.itemRepository);
	}

	@Override
	public void delete(O obj) {
		obj.delete();
		this.store(obj);
	}

}
