package io.dddrive.jooq.obj;

import java.util.HashMap;
import java.util.Map;

import org.jooq.DSLContext;
import org.jooq.TableRecord;
import org.springframework.beans.factory.annotation.Autowired;

import io.dddrive.ddd.model.Aggregate;
import io.dddrive.ddd.model.AggregatePersistenceProvider;
import io.dddrive.ddd.model.AggregateRepository;
import io.dddrive.jooq.util.SqlUtils;
import io.dddrive.jooq.util.SqlUtils.SearchConditionProvider;
import io.dddrive.obj.model.Obj;
import io.dddrive.obj.model.base.ObjRepositoryBase;
import io.dddrive.property.model.PropertyProvider;

public abstract class JooqObjExtnRepositoryBase<O extends Obj, V extends TableRecord<?>>
		extends ObjRepositoryBase<O, V>
		implements ObjExtnPropertyProviderMixin {

	private DSLContext dslContext;
	private SqlUtils sqlUtils;
	private final Map<String, Object> dbConfigMap = new HashMap<>();

	public JooqObjExtnRepositoryBase(
			Class<? extends AggregateRepository<O, V>> repoIntfClass,
			Class<? extends Obj> intfClass,
			Class<? extends Obj> baseClass,
			String aggregateTypeId) {
		super(repoIntfClass, intfClass, baseClass, aggregateTypeId);
		this.mapProperties();
	}

	@Autowired
	protected void setDSLContext(DSLContext dslContext) {
		this.dslContext = dslContext;
	}

	@Autowired
	protected void setSearchConditionProvider(SearchConditionProvider searchConditionProvider) {
		this.sqlUtils = new SqlUtils(searchConditionProvider);
	}

	@Override
	@SuppressWarnings("unchecked")
	public AggregatePersistenceProvider<O> getPersistenceProvider() {
		return (AggregatePersistenceProvider<O>) this;
	}

	@Override
	public PropertyProvider getPropertyProvider() {
		return this;
	}

	@Override
	public final Class<? extends Aggregate> getEntityClass() {
		return this.getAggregateClass();
	}

	@Override
	public final Map<String, Object> dbConfigMap() {
		return this.dbConfigMap;
	}

	public final DSLContext dslContext() {
		return this.dslContext;
	}

	public SqlUtils sqlUtils() {
		return this.sqlUtils;
	}

}
