package io.dddrive.jooq.doc;

import io.dddrive.ddd.model.PartPersistenceProvider;
import io.dddrive.doc.model.Doc;
import io.dddrive.doc.model.DocPart;
import io.dddrive.jooq.ddd.JooqPartRepositoryBase;
import io.dddrive.property.model.PropertyProvider;

public abstract class JooqDocPartRepositoryBase<D extends Doc, P extends DocPart<D>>
		extends JooqPartRepositoryBase<D, P>
		implements DocPartPropertyProviderMixin {

	protected JooqDocPartRepositoryBase(
			Class<? extends D> aggregateIntfClass,
			Class<? extends DocPart<D>> intfClass,
			Class<? extends DocPart<D>> baseClass,
			String partTypeId) {
		super(aggregateIntfClass, intfClass, baseClass, partTypeId);
		this.mapProperties();
	}

	@Override
	public PartPersistenceProvider<D, P> getPersistenceProvider() {
		return this;
	}

	@Override
	public PropertyProvider getPropertyProvider() {
		return this;
	}

}
