package io.dddrive.enums.adapter.api.jsonapi.dto;

import io.crnk.core.resource.annotations.JsonApiId;
import io.dddrive.ddd.model.Aggregate;
import io.dddrive.doc.model.Doc;
import io.dddrive.enums.model.Enumerated;
import io.dddrive.obj.model.Obj;

public class EnumeratedDto {

	@JsonApiId
	private String id;

	private String name;

	private EnumeratedDto itemType;

	EnumeratedDto() {
	}

	EnumeratedDto(String id, String name) {
		this.id = id;
		this.name = name;
	}

	EnumeratedDto(String id, String name, EnumeratedDto itemType) {
		this.id = id;
		this.name = name;
		this.itemType = itemType;
	}

	public String getId() {
		return this.id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public EnumeratedDto getItemType() {
		return this.itemType;
	}

	public void setItemType(EnumeratedDto itemType) {
		this.itemType = itemType;
	}

	public static EnumeratedDto of(String id, String name) {
		return new EnumeratedDto(id, name);
	}

	public static EnumeratedDto of(String id, String name, EnumeratedDto itemType) {
		return new EnumeratedDto(id, name, itemType);
	}

	public static EnumeratedDto fromEnum(Enumerated e) {
		if (e == null) {
			return null;
		}
		return new EnumeratedDto(e.getId(), e.getName());
	}

	public static EnumeratedDto fromAggregate(Aggregate a) {
		if (a == null) {
			return null;
		}
		return new EnumeratedDto(a.getId().toString(), a.getCaption(), fromEnum(a.getMeta().getAggregateType()));
	}

	public static EnumeratedDto fromObj(Obj obj) {
		return fromAggregate(obj);
	}

	public static EnumeratedDto fromDoc(Doc doc) {
		return fromAggregate(doc);
	}

}
