
package io.dddrive.doc.model.enums;

import java.util.ArrayList;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.dddrive.enums.model.base.EnumeratedBase;

public class CodeCaseDef extends EnumeratedBase {

	public final List<CodeCaseStage> caseStages = new ArrayList<>();

	public CodeCaseDef(CodeCaseDefEnum enumeration, String id, String name) {
		super(enumeration, id, name);
	}

	public void addCaseStage(CodeCaseStage stage) {
		this.caseStages.add(stage);
	}

	@JsonIgnore
	public List<CodeCaseStage> getCaseStages() {
		return List.copyOf(this.caseStages);
	}

}
