
package io.dddrive.doc.model.base;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Autowired;

import io.dddrive.ddd.model.AggregateRepository;
import io.dddrive.ddd.model.base.AggregateRepositoryBase;
import io.dddrive.doc.model.Doc;
import io.dddrive.doc.model.DocPartItemRepository;
import io.dddrive.doc.model.DocPartTransitionRepository;
import io.dddrive.doc.model.DocRepository;

public abstract class DocRepositoryBase<D extends Doc, V extends Object>
		extends AggregateRepositoryBase<D, V>
		implements DocRepository<D, V> {

	private DocPartTransitionRepository transitionRepository;
	private DocPartItemRepository itemRepository;

	protected DocRepositoryBase(
			Class<? extends AggregateRepository<D, V>> repoIntfClass,
			Class<? extends Doc> intfClass,
			Class<? extends Doc> baseClass,
			String aggregateTypeId) {
		super(repoIntfClass, intfClass, baseClass, aggregateTypeId);
	}

	@Autowired
	void setTransitionRepository(DocPartTransitionRepository transitionRepository) {
		this.transitionRepository = transitionRepository;
	}

	@Override
	public DocPartTransitionRepository getTransitionRepository() {
		return this.transitionRepository;
	}

	@Autowired
	void setItemRepository(DocPartItemRepository itemRepository) {
		this.itemRepository = itemRepository;
	}

	@Override
	public DocPartItemRepository getItemRepository() {
		return this.itemRepository;
	}

	@Override
	@PostConstruct
	public void registerPartRepositories() {
		this.addPartRepository(this.getTransitionRepository());
		this.addPartRepository(this.getItemRepository());
	}

}
