
package io.dddrive.ddd.service.api;

import io.dddrive.ddd.model.Aggregate;

/**
 * An Aggregate Cache
 */
public interface AggregateCache<A extends Aggregate> {

	/**
	 * Lookup (and cache) an Aggregate with given id return aggregate
	 *
	 * @return aggregate
	 * @throws NoDataFound
	 *           when aggregate not found
	 */
	A get(Integer id);

	/**
	 * Lookup (and cache) an Aggregate by given key return aggregate throws
	 * NoDataFound exception when aggregate not found
	 */
	A get(String key);

}
