
package io.dddrive.ddd.model.enums;

import io.dddrive.app.service.api.AppContextSPI;
import io.dddrive.enums.model.base.EnumerationBase;

public class CodeAggregateTypeEnum extends EnumerationBase<CodeAggregateType> {

	private static CodeAggregateTypeEnum INSTANCE;

	public CodeAggregateTypeEnum(AppContextSPI appContext) {
		super(CodeAggregateType.class, appContext);
		INSTANCE = this;
	}

	public static CodeAggregateTypeEnum getInstance() {
		return INSTANCE;
	}

	@Override
	public void addItem(CodeAggregateType item) {
		super.addItem(item);
	}

	public static CodeAggregateType getAggregateType(String aggregateTypeId) {
		return INSTANCE.getItem(aggregateTypeId);
	}

}
