package io.dddrive.ddd.adapter.api.jsonapi.dto;

import java.time.OffsetDateTime;
import java.util.List;

import io.crnk.core.resource.meta.MetaInformation;
import io.dddrive.enums.adapter.api.jsonapi.dto.EnumeratedDto;
import io.dddrive.validation.adapter.api.jsonapi.dto.AggregatePartValidationDto;

public interface AggregateMetaDto extends MetaInformation {

	// Meta from Server
	EnumeratedDto getItemType();

	EnumeratedDto getOwner();

	Integer getVersion();

	EnumeratedDto getCreatedByUser();

	OffsetDateTime getCreatedAt();

	EnumeratedDto getModifiedByUser();

	OffsetDateTime getModifiedAt();

	List<AggregatePartValidationDto> getValidations();

	// Meta from Client
	Integer getClientVersion();

	List<String> getOperations();

	default boolean hasOperation(String operation) {
		return this.getOperations() != null && this.getOperations().contains(operation);
	}

}
