package io.dddrive.ddd.adapter.api.jsonapi.dto;

import io.crnk.core.resource.annotations.JsonApiField;
import io.crnk.core.resource.annotations.JsonApiId;
import io.crnk.core.resource.annotations.JsonApiMetaInformation;
import io.dddrive.ddd.model.Aggregate;
import io.dddrive.enums.adapter.api.jsonapi.dto.EnumeratedDto;

public interface AggregateDto<A extends Aggregate> {

	@JsonApiMetaInformation
	AggregateMetaDto getMeta();

	@JsonApiId
	Integer getId();

	// Read: for orderbooks, write: for creation
	EnumeratedDto getTenant();

	// Read: for orderbooks, write: for updates
	EnumeratedDto getOwner();

	String getCaption();

	// For explicit filtering in SaaS session
	@JsonApiField(readable = false, filterable = true)
	default Integer getTenantId() {
		return null;
	}

	@JsonApiField(readable = false, filterable = true)
	default String getSearchText() {
		return null;
	}

}
