package io.dddrive.ddd.adapter.api.jsonapi.base;

import org.springframework.beans.factory.annotation.Autowired;

import io.dddrive.oe.model.ObjTenant;
import io.dddrive.oe.model.ObjUser;
import io.dddrive.oe.service.api.ObjTenantCache;
import io.dddrive.oe.service.api.ObjUserCache;

public abstract class AggregateDtoAdapterBase {

	private ObjTenantCache tenantCache = null;
	private ObjUserCache userCache = null;

	@Autowired
	void setTenantCache(ObjTenantCache tenantCache) {
		this.tenantCache = tenantCache;
	}

	@Autowired
	void setUserCache(ObjUserCache userCache) {
		this.userCache = userCache;
	}

	protected ObjTenant getTenant(Integer tenantId) {
		return this.tenantCache.get(tenantId);
	}

	protected ObjUserCache getUserCache() {
		return this.userCache;
	}

	protected ObjUser getUser(Integer userId) {
		return this.userCache.get(userId);
	}

}
