
package io.dddrive.app.service.api.base;

import java.util.HashMap;
import java.util.Map;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

import io.dddrive.app.model.RequestContext;
import io.dddrive.app.service.api.AppContext;
import io.dddrive.app.service.api.AppContextSPI;
import io.dddrive.ddd.model.Aggregate;
import io.dddrive.ddd.model.AggregatePersistenceProvider;
import io.dddrive.ddd.model.AggregateRepository;
import io.dddrive.ddd.model.Part;
import io.dddrive.ddd.model.PartPersistenceProvider;
import io.dddrive.ddd.model.PartRepository;
import io.dddrive.ddd.service.api.AggregateCache;
import io.dddrive.enums.model.Enumerated;
import io.dddrive.enums.model.Enumeration;
import io.dddrive.property.model.PropertyProvider;

public abstract class AppContextBase implements AppContext, AppContextSPI {

	private final ApplicationEventPublisher applicationEventPublisher;
	private final Repositories repos;
	private final Enumerations enums;
	private final Map<Class<?>, PropertyProvider> propertyProviders = new HashMap<>();
	private final Map<Class<?>, AggregatePersistenceProvider<?>> aggregatePersistenceProviders = new HashMap<>();
	private final Map<Class<?>, PartPersistenceProvider<?, ? extends Part<?>>> partPersistenceProviders = new HashMap<>();
	private final Map<Class<? extends Aggregate>, AggregateCache<?>> cacheByIntf = new HashMap<>();
	private final BeanFactory beanFactory;

	protected AppContextBase(ApplicationEventPublisher applicationEventPublisher, BeanFactory beanFactory) {
		this.applicationEventPublisher = applicationEventPublisher;
		this.repos = new Repositories();
		this.enums = new Enumerations();
		this.beanFactory = beanFactory;
	}

	@Override
	public RequestContext getRequestContext() {
		return this.beanFactory.getBean(RequestContext.class);
	}

	@Override
	public void addRepository(Class<? extends Aggregate> intfClass,
			AggregateRepository<? extends Aggregate, ? extends Object> repo) {
		this.repos.addRepository(intfClass, repo);
	}

	@Override
	public <A extends Aggregate> AggregateRepository<A, ?> getRepository(Class<A> intfClass) {
		return this.repos.getRepository(intfClass);
	}

	@Override
	public PropertyProvider getPropertyProvider(Class<?> intfClass) {
		return this.propertyProviders.get(intfClass);
	}

	@Override
	@SuppressWarnings("unchecked")
	public <A extends Aggregate> AggregatePersistenceProvider<A> getAggregatePersistenceProvider(Class<A> intfClass) {
		return (AggregatePersistenceProvider<A>) this.aggregatePersistenceProviders.get(intfClass);
	}

	@Override
	@SuppressWarnings("unchecked")
	public <A extends Aggregate, P extends Part<A>> PartPersistenceProvider<A, P> getPartPersistenceProvider(
			Class<? extends Part<A>> intfClass) {
		return (PartPersistenceProvider<A, P>) this.partPersistenceProviders.get(intfClass);
	}

	@Override
	public void addCache(Class<? extends Aggregate> intfClass, AggregateCache<? extends Aggregate> cache) {
		this.cacheByIntf.put(intfClass, cache);
	}

	@Override
	@SuppressWarnings("unchecked")
	public <Aggr extends Aggregate> AggregateCache<Aggr> getCache(Class<Aggr> intfClass) {
		return (AggregateCache<Aggr>) this.cacheByIntf.get(intfClass);
	}

	@Override
	public <A extends Aggregate> void addPartRepository(Class<? extends Part<A>> intfClass,
			PartRepository<A, ? extends Part<A>> repo) {
		this.repos.addPartRepository(intfClass, repo);
	}

	@Override
	public <A extends Aggregate, P extends Part<A>> PartRepository<A, P> getPartRepository(Class<P> intfClass) {
		return this.repos.getPartRepository(intfClass);
	}

	@Override
	public <E extends Enumerated> void addEnumeration(Class<E> enumClass, Enumeration<E> enumeration) {
		this.enums.addEnumeration(enumClass, enumeration);
	}

	@Override
	public <E extends Enumerated> Enumeration<E> getEnumeration(Class<E> enumClass) {
		return this.enums.getEnumeration(enumClass);
	}

	@Override
	public Enumeration<? extends Enumerated> getEnumeration(String module, String name) {
		return this.enums.getEnumeration(module, name);
	}

	@Override
	public <E extends Enumerated> E getEnumerated(Class<E> enumClass, String itemId) {
		return this.enums.getEnumeration(enumClass).getItem(itemId);
	}

	@Override
	public void publishApplicationEvent(ApplicationEvent applicationEvent) {
		this.applicationEventPublisher.publishEvent(applicationEvent);
	}

}
