
package io.dddrive.app.model.base;

import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import io.dddrive.app.model.RequestContext;
import io.dddrive.ddd.model.Aggregate;
import io.dddrive.oe.model.ObjUser;

public abstract class RequestContextBase implements RequestContext {

	private final ObjUser user;
	private final Integer tenantId;
	private final Map<Integer, Aggregate> aggregates = new ConcurrentHashMap<>();

	public RequestContextBase(ObjUser user, Integer tenantId) {
		this.user = user;
		this.tenantId = tenantId;
	}

	@Override
	public ObjUser getUser() {
		return this.user;
	}

	@Override
	public Integer getTenantId() {
		return this.tenantId;
	}

	@Override
	public boolean hasAggregate(Integer id) {
		return this.aggregates.containsKey(id);
	}

	@Override
	public Aggregate getAggregate(Integer id) {
		return this.aggregates.get(id);
	}

	@Override
	public void addAggregate(Aggregate aggregate) {
		this.aggregates.put(aggregate.getId(), aggregate);
	}

	@Override
	public LocalDate getCurrentDate() {
		return LocalDate.now();
	}

	@Override
	public OffsetDateTime getCurrentTime() {
		return OffsetDateTime.now();
	}

}
