/*
 * Decompiled with CFR 0.152.
 */
package io.dddrive.property.model.impl;

import io.dddrive.ddd.model.Aggregate;
import io.dddrive.ddd.model.base.PartSPI;
import io.dddrive.ddd.model.enums.CodePartListType;
import io.dddrive.property.model.AggregatePartItem;
import io.dddrive.property.model.AggregateResolver;
import io.dddrive.property.model.ReferenceSetProperty;
import io.dddrive.property.model.base.EntityWithPropertiesSPI;
import io.dddrive.property.model.base.PropertyBase;
import io.dddrive.util.Invariant;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ReferenceSetPropertyImpl<A extends Aggregate>
extends PropertyBase<A>
implements ReferenceSetProperty<A> {
    private final String name;
    private final CodePartListType partListType;
    private Set<AggregatePartItem<?>> itemSet = new HashSet();

    public ReferenceSetPropertyImpl(EntityWithPropertiesSPI entity, String name, CodePartListType partListType, AggregateResolver<A> repository) {
        super(entity);
        this.name = name;
        this.partListType = partListType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public CodePartListType getPartListType() {
        return this.partListType;
    }

    @Override
    public void clearItems() {
        Invariant.requireThis(this.isWritable(), "not frozen");
        this.itemSet.forEach(item -> ((PartSPI)((Object)item)).delete());
        this.itemSet.clear();
        this.getEntity().afterClear(this);
    }

    @Override
    public void addItem(Integer id) {
        Invariant.requireThis(this.isWritable(), "not frozen");
        Invariant.requireThis(id != null, "aggregateId not null");
        if (id == null) {
            return;
        }
        if (!this.hasItem(id)) {
            Invariant.assertThis(this.isValidAggregateId(id), "valid aggregate id [" + id + "]");
            AggregatePartItem part = (AggregatePartItem)this.getEntity().addPart(this, this.partListType);
            Invariant.assertThis(part != null, "entity " + this.getEntity().getClass().getSimpleName() + "created a part for " + this.partListType.getId() + " (make sure to compare property with .equals() in addPart)");
            if (part == null) {
                return;
            }
            part.setItemId(id.toString());
            this.itemSet.add(part);
            this.getEntity().afterAdd(this);
        }
    }

    @Override
    public Set<Integer> getItems() {
        return Set.copyOf(this.itemSet.stream().map(item -> Integer.valueOf(item.getItemId())).toList());
    }

    @Override
    public boolean hasItem(Integer aggregateId) {
        for (AggregatePartItem<?> part : this.itemSet) {
            if (!part.getItemId().equals(aggregateId.toString())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeItem(Integer aggregateId) {
        Invariant.requireThis(this.isWritable(), "not frozen");
        Invariant.requireThis(aggregateId != null, "aggregateId not null");
        if (aggregateId == null) {
            return;
        }
        if (this.hasItem(aggregateId)) {
            AggregatePartItem part = this.itemSet.stream().filter(p -> p.getItemId().equals(aggregateId.toString())).findAny().get();
            ((PartSPI)((Object)part)).delete();
            this.itemSet.remove(part);
            this.getEntity().afterRemove(this);
        }
    }

    public void doBeforeStore() {
        int seqNr = 0;
        Iterator<AggregatePartItem<?>> it = this.itemSet.iterator();
        while (it.hasNext()) {
            it.next().setSeqNr(seqNr++);
        }
    }

    @Override
    public void loadReferences(Collection<? extends AggregatePartItem<?>> partList) {
        this.itemSet.clear();
        partList.forEach(p -> this.itemSet.add((AggregatePartItem<?>)p));
    }

    private boolean isValidAggregateId(Integer id) {
        return true;
    }
}

