/*
 * Decompiled with CFR 0.152.
 */
package io.dddrive.property.model.base;

import io.dddrive.ddd.model.Aggregate;
import io.dddrive.ddd.model.Part;
import io.dddrive.enums.model.Enumerated;
import io.dddrive.property.model.EntityWithProperties;
import io.dddrive.property.model.EnumProperty;
import io.dddrive.property.model.EnumSetProperty;
import io.dddrive.property.model.PartListProperty;
import io.dddrive.property.model.Property;
import io.dddrive.property.model.PropertyProvider;
import io.dddrive.property.model.ReferenceProperty;
import io.dddrive.property.model.ReferenceSetProperty;
import io.dddrive.property.model.SimpleProperty;
import io.dddrive.property.model.base.EntityWithPropertiesSPI;
import io.dddrive.property.model.wrapper.EnumPropertyWrapper;
import io.dddrive.property.model.wrapper.EnumSetPropertyWrapper;
import io.dddrive.property.model.wrapper.PartListPropertyWrapper;
import io.dddrive.property.model.wrapper.ReferencePropertyWrapper;
import io.dddrive.property.model.wrapper.ReferenceSetPropertyWrapper;
import io.dddrive.property.model.wrapper.SimplePropertyWrapper;
import io.dddrive.util.Invariant;
import java.util.List;
import java.util.Map;

public interface EntityWithPropertiesMixin
extends EntityWithProperties,
EntityWithPropertiesSPI {
    public Map<String, Property<?>> propertyMap();

    @Override
    public PropertyProvider getPropertyProvider();

    @Override
    default public boolean hasProperty(String name) {
        return this.propertyMap().containsKey(name);
    }

    @Override
    default public Property<?> getProperty(String name) {
        return this.propertyMap().get(name);
    }

    @Override
    default public List<Property<?>> getProperties() {
        return this.propertyMap().values().stream().toList();
    }

    default public void addProperty(Property<?> property) {
        Invariant.requireThis(property.getName() != null, "property has name");
        Invariant.requireThis(!this.hasProperty(property.getName()), "property [" + property.getName() + "] is unique");
        this.propertyMap().put(property.getName(), property);
    }

    default public <T> SimpleProperty<T> addSimpleProperty(String name, Class<T> type) {
        SimpleProperty<T> property = this.getPropertyProvider() == null ? new SimplePropertyWrapper<T>(this, name, type) : this.getPropertyProvider().getSimpleProperty(this, name, type);
        this.addProperty(property);
        return property;
    }

    default public <E extends Enumerated> EnumProperty<E> addEnumProperty(String name, Class<E> type) {
        EnumProperty<E> property = this.getPropertyProvider() == null ? new EnumPropertyWrapper<E>((EntityWithPropertiesSPI)this, name, type) : this.getPropertyProvider().getEnumProperty(this, name, type);
        this.addProperty(property);
        return property;
    }

    default public <E extends Enumerated> EnumSetProperty<E> addEnumSetProperty(String name, Class<E> type) {
        EnumSetProperty<E> property = this.getPropertyProvider() == null ? new EnumSetPropertyWrapper<E>((EntityWithPropertiesSPI)this, name, type) : this.getPropertyProvider().getEnumSetProperty(this, name, type);
        this.addProperty(property);
        return property;
    }

    default public <A extends Aggregate> ReferenceProperty<A> addReferenceProperty(String name, Class<A> type) {
        ReferenceProperty<A> property = null;
        property = this.getPropertyProvider() == null ? new ReferencePropertyWrapper<A>((EntityWithPropertiesSPI)this, name, type) : this.getPropertyProvider().getReferenceProperty(this, name, type);
        this.addProperty(property);
        return property;
    }

    default public <A extends Aggregate> ReferenceSetProperty<A> addReferenceSetProperty(String name, Class<A> type) {
        ReferenceSetProperty<A> property = this.getPropertyProvider() == null ? new ReferenceSetPropertyWrapper<A>((EntityWithPropertiesSPI)this, name, type) : this.getPropertyProvider().getReferenceSetProperty(this, name, type);
        this.addProperty(property);
        return property;
    }

    default public <P extends Part<?>> PartListProperty<P> addPartListProperty(String name, Class<P> type) {
        PartListProperty<P> property = this.getPropertyProvider() == null ? new PartListPropertyWrapper<P>((EntityWithPropertiesSPI)this, name, type) : this.getPropertyProvider().getPartListProperty(this, name, type);
        this.addProperty(property);
        return property;
    }
}

