/*
 * Decompiled with CFR 0.152.
 */
package io.dddrive.obj.model.base;

import io.dddrive.ddd.model.Part;
import io.dddrive.ddd.model.PartRepository;
import io.dddrive.ddd.model.base.PartBase;
import io.dddrive.ddd.model.enums.CodePartListType;
import io.dddrive.obj.model.Obj;
import io.dddrive.obj.model.ObjPart;
import io.dddrive.obj.model.ObjPartItemRepository;
import io.dddrive.obj.model.ObjRepository;
import io.dddrive.property.model.EnumSetProperty;
import io.dddrive.property.model.Property;
import io.dddrive.property.model.ReferenceSetProperty;
import java.util.List;

public abstract class ObjPartBase<O extends Obj>
extends PartBase<O>
implements ObjPart<O> {
    protected ObjPartBase(PartRepository<O, ?> repository, O obj, Object state) {
        super(repository, obj, state);
    }

    protected ObjRepository<O, ?> getObjRepository() {
        return (ObjRepository)((Obj)this.getAggregate()).getMeta().getRepository();
    }

    @Override
    public void doAssignParts() {
        super.doAssignParts();
        ObjPartItemRepository itemRepository = this.getObjRepository().getItemRepository();
        for (Property<?> property : this.getProperties()) {
            List partList;
            if (property instanceof EnumSetProperty) {
                EnumSetProperty enumSet = (EnumSetProperty)property;
                partList = itemRepository.getParts(this, enumSet.getPartListType());
                enumSet.loadEnums(partList);
                continue;
            }
            if (!(property instanceof ReferenceSetProperty)) continue;
            ReferenceSetProperty referenceSet = (ReferenceSetProperty)property;
            partList = itemRepository.getParts(this, referenceSet.getPartListType());
            referenceSet.loadReferences(partList);
        }
    }

    @Override
    public Part<?> addPart(Property<?> property, CodePartListType partListType) {
        if (property instanceof EnumSetProperty) {
            return this.getObjRepository().getItemRepository().create(this, partListType);
        }
        if (property instanceof ReferenceSetProperty) {
            return this.getObjRepository().getItemRepository().create(this, partListType);
        }
        return super.addPart(property, partListType);
    }
}

