/*
 * Decompiled with CFR 0.152.
 */
package io.dddrive.jooq.util;

import io.crnk.core.queryspec.Direction;
import io.crnk.core.queryspec.FilterOperator;
import io.crnk.core.queryspec.FilterSpec;
import io.crnk.core.queryspec.SortSpec;
import io.dddrive.util.CrnkUtils;
import io.dddrive.util.CustomFilters;
import io.dddrive.util.Invariant;
import io.dddrive.util.StringUtils;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.SortField;
import org.jooq.SortOrder;
import org.jooq.Table;
import org.jooq.impl.DSL;

public class SqlUtils {
    private final SearchConditionProvider searchConditionProvider;

    public SqlUtils(SearchConditionProvider searchConditionProvider) {
        this.searchConditionProvider = searchConditionProvider;
    }

    public Condition andFilter(Condition whereClause, Table<?> table, Field<Integer> idField, FilterSpec filter) {
        return whereClause.and(this.filter(table, idField, filter));
    }

    public Condition orFilter(Condition whereClause, Table<?> table, Field<Integer> idField, FilterSpec filter) {
        List<Condition> conditions = filter.getExpression().stream().map(f -> this.filter(table, idField, (FilterSpec)f)).toList();
        return whereClause.and(DSL.or(conditions));
    }

    public List<SortField<?>> sortFilter(Table<?> table, List<SortSpec> sortSpec) {
        return sortSpec.stream().map(s -> table.field(StringUtils.toSnakeCase(s.getPath().toString())).sort(Direction.ASC.equals((Object)s.getDirection()) ? SortOrder.ASC : SortOrder.DESC).nullsLast()).collect(Collectors.toList());
    }

    private Condition closedFilter(Table<?> table, FilterSpec filter) {
        Field field = table.field("closed_at");
        Invariant.assertThis(field != null, "known field closed_at");
        if (field == null) {
            return null;
        }
        Boolean value = (Boolean)filter.getValue();
        if (value.booleanValue()) {
            if (filter.getOperator() == FilterOperator.EQ) {
                return field.isNotNull();
            }
            if (filter.getOperator() == FilterOperator.NEQ) {
                return field.isNull();
            }
        } else if (!value.booleanValue()) {
            if (filter.getOperator() == FilterOperator.EQ) {
                return field.isNull();
            }
            if (filter.getOperator() == FilterOperator.NEQ) {
                return field.isNotNull();
            }
        }
        return DSL.trueCondition();
    }

    private Integer toInteger(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray() && ((Object[])value).length == 1) {
            return this.toInteger(((Object[])value)[0]);
        }
        if (value instanceof Collection && ((Collection)value).size() == 1) {
            return this.toInteger(((Collection)value).stream().toList().get(0));
        }
        if (value.getClass() == Integer.class) {
            return (Integer)value;
        }
        if (value.getClass() == String.class) {
            return Integer.valueOf((String)value);
        }
        Invariant.assertThis(false, String.valueOf(value) + " (" + String.valueOf(value.getClass()) + ") is an integer");
        return null;
    }

    private Condition integerFilter(Field<Integer> field, FilterSpec filter) {
        if (filter.getValue() instanceof Collection) {
            if (filter.getOperator() == CustomFilters.IN || filter.getOperator() == FilterOperator.EQ) {
                return field.in((Collection)filter.getValue());
            }
            Invariant.assertThis(false, "supported integer filter operator " + String.valueOf(filter.getOperator()) + " on " + String.valueOf(filter.getValue()));
        } else {
            Integer value = this.toInteger(filter.getValue());
            if (filter.getOperator() == FilterOperator.EQ) {
                if (value != null) {
                    return field.eq((Object)value);
                }
                return field.isNull();
            }
            if (filter.getOperator() == FilterOperator.NEQ) {
                if (value != null) {
                    return field.eq((Object)value).not();
                }
                return field.isNotNull();
            }
            if (filter.getOperator() == FilterOperator.GT) {
                return field.gt((Object)value);
            }
            if (filter.getOperator() == FilterOperator.GE) {
                return field.ge((Object)value);
            }
            if (filter.getOperator() == FilterOperator.LT) {
                return field.lt((Object)value);
            }
            if (filter.getOperator() == FilterOperator.LE) {
                return field.le((Object)value);
            }
        }
        Invariant.assertThis(false, "supported integer filter operator " + String.valueOf(filter.getOperator()) + " on " + String.valueOf(filter.getValue()));
        return DSL.falseCondition();
    }

    private Condition stringFilter(Field<String> field, FilterSpec filter) {
        String value;
        if (filter.getOperator() == CustomFilters.IN) {
            Set value2 = (Set)filter.getValue();
            Condition inner = DSL.noCondition();
            for (String val : value2) {
                inner = inner.or(field.eq((Object)val));
            }
            return inner;
        }
        String string = value = filter.getValue() != null ? filter.getValue().toString() : null;
        if (filter.getOperator() == FilterOperator.EQ) {
            if (value != null) {
                return field.eq((Object)value);
            }
            return field.isNull().or(field.eq((Object)""));
        }
        if (filter.getOperator() == FilterOperator.NEQ) {
            if (value != null) {
                return field.eq((Object)value).not();
            }
            return field.isNotNull().and(field.eq((Object)"").not());
        }
        if (filter.getOperator() == FilterOperator.GT) {
            return field.gt((Object)value);
        }
        if (filter.getOperator() == FilterOperator.GE) {
            return field.ge((Object)value);
        }
        if (filter.getOperator() == FilterOperator.LT) {
            return field.lt((Object)value);
        }
        if (filter.getOperator() == FilterOperator.LE) {
            return field.le((Object)value);
        }
        if (filter.getOperator() == FilterOperator.LIKE && value != null) {
            return DSL.lower(field).like(value.replace("*", "%"));
        }
        Invariant.assertThis(false, "supported string filter operator " + String.valueOf(filter.getOperator()));
        return DSL.falseCondition();
    }

    private Condition booleanFilter(Field<Boolean> field, FilterSpec filter) {
        Boolean value = (Boolean)filter.getValue();
        if (filter.getOperator() == FilterOperator.EQ) {
            return field.eq((Object)value);
        }
        Invariant.assertThis(false, "supported boolean filter operator " + String.valueOf(filter.getOperator()));
        return DSL.falseCondition();
    }

    private Condition localDateTimeFilter(Field<LocalDateTime> field, FilterSpec filter) {
        LocalDateTime value = (LocalDateTime)filter.getValue();
        if (filter.getOperator() == FilterOperator.EQ) {
            if (value != null) {
                return field.eq((Object)value);
            }
            return field.isNull();
        }
        if (filter.getOperator() == FilterOperator.NEQ) {
            if (value != null) {
                return field.eq((Object)value).not();
            }
            return field.isNotNull();
        }
        if (filter.getOperator() == FilterOperator.GT) {
            return field.gt((Object)value);
        }
        if (filter.getOperator() == FilterOperator.GE) {
            return field.ge((Object)value);
        }
        if (filter.getOperator() == FilterOperator.LT) {
            return field.lt((Object)value);
        }
        if (filter.getOperator() == FilterOperator.LE) {
            return field.le((Object)value);
        }
        Invariant.assertThis(false, "supported local date time filter operator " + String.valueOf(filter.getOperator()));
        return DSL.falseCondition();
    }

    private Condition offsetDateTimeFilter(Field<OffsetDateTime> field, FilterSpec filter) {
        OffsetDateTime value = (OffsetDateTime)filter.getValue();
        if (value == null) {
            if (filter.getOperator() == FilterOperator.EQ) {
                return field.isNull();
            }
            if (filter.getOperator() == FilterOperator.NEQ) {
                return field.isNotNull();
            }
        } else {
            ZoneOffset zoneOffset = ZoneId.systemDefault().getRules().getOffset(Instant.now());
            value = value.atZoneSameInstant(zoneOffset).toOffsetDateTime();
            if (filter.getOperator() == FilterOperator.EQ) {
                return field.eq((Object)value);
            }
            if (filter.getOperator() == FilterOperator.NEQ) {
                return field.eq((Object)value).not();
            }
            if (filter.getOperator() == FilterOperator.GT) {
                return field.gt((Object)value);
            }
            if (filter.getOperator() == FilterOperator.GE) {
                return field.ge((Object)value);
            }
            if (filter.getOperator() == FilterOperator.LT) {
                return field.lt((Object)value);
            }
            if (filter.getOperator() == FilterOperator.LE) {
                return field.le((Object)value);
            }
        }
        Invariant.assertThis(false, "supported offset date time filter operator " + String.valueOf(filter.getOperator()));
        return DSL.falseCondition();
    }

    private Condition filter(Table<?> table, Field<Integer> idField, FilterSpec filter) {
        String fieldName = StringUtils.toSnakeCase(CrnkUtils.getPath(filter));
        if ("search_text".equals(fieldName)) {
            return this.searchConditionProvider.apply(idField, filter);
        }
        if ("is_closed".equals(fieldName)) {
            return this.closedFilter(table, filter);
        }
        Field field = table.field(fieldName);
        Invariant.assertThis(field != null, "known field " + fieldName);
        if (field == null) {
            return null;
        }
        if (field.getType() == Integer.class) {
            return this.integerFilter((Field<Integer>)field, filter);
        }
        if (field.getType() == String.class) {
            return this.stringFilter((Field<String>)field, filter);
        }
        if (field.getType() == Boolean.class) {
            return this.booleanFilter((Field<Boolean>)field, filter);
        }
        if (field.getType() == LocalDateTime.class) {
            return this.localDateTimeFilter((Field<LocalDateTime>)field, filter);
        }
        if (field.getType() == OffsetDateTime.class) {
            return this.offsetDateTimeFilter((Field<OffsetDateTime>)field, filter);
        }
        Invariant.assertThis(false, "supported field type " + fieldName + ": " + String.valueOf(field.getType()));
        return DSL.falseCondition();
    }

    public static interface SearchConditionProvider {
        public Condition apply(Field<Integer> var1, FilterSpec var2);
    }
}

