/*
 * Decompiled with CFR 0.152.
 */
package io.dddrive.jooq.property;

import io.dddrive.ddd.model.Aggregate;
import io.dddrive.property.model.AggregateResolver;
import io.dddrive.property.model.ReferenceProperty;
import io.dddrive.property.model.base.EntityWithPropertiesSPI;
import io.dddrive.property.model.base.PropertyBase;
import io.dddrive.util.Invariant;
import java.util.Objects;
import org.jooq.Field;
import org.jooq.UpdatableRecord;

public class ReferencePropertyImpl<A extends Aggregate>
extends PropertyBase<A>
implements ReferenceProperty<A> {
    private final UpdatableRecord<?> dbRecord;
    private final String name;
    private final Field<Integer> field;
    private final AggregateResolver<A> resolver;

    public ReferencePropertyImpl(EntityWithPropertiesSPI entity, UpdatableRecord<?> dbRecord, String name, Field<Integer> field, AggregateResolver<A> resolver) {
        super(entity);
        this.dbRecord = dbRecord;
        this.name = name;
        this.field = field;
        this.resolver = resolver;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Integer getId() {
        return (Integer)this.dbRecord.getValue(this.field);
    }

    @Override
    public void setId(Integer id) {
        Invariant.requireThis(this.isWritable(), "not frozen");
        if (Objects.equals(this.getId(), id)) {
            return;
        }
        Invariant.assertThis(this.isValidAggregateId(id), "valid aggregate id [" + id + "]");
        this.dbRecord.setValue(this.field, (Object)id);
        this.getEntity().afterSet(this);
    }

    @Override
    public A getValue() {
        return this.getId() == null ? null : (A)this.resolver.get(this.getId());
    }

    @Override
    public void setValue(A value) {
        this.setId(value == null ? null : value.getId());
    }

    private boolean isValidAggregateId(Integer id) {
        return true;
    }
}

