/*
 * Decompiled with CFR 0.152.
 */
package io.dddrive.jooq.property;

import io.dddrive.app.service.api.AppContext;
import io.dddrive.ddd.model.Aggregate;
import io.dddrive.ddd.model.Part;
import io.dddrive.ddd.model.enums.CodePartListType;
import io.dddrive.ddd.model.enums.CodePartListTypeEnum;
import io.dddrive.ddd.service.api.AggregateCache;
import io.dddrive.enums.model.Enumerated;
import io.dddrive.enums.model.Enumeration;
import io.dddrive.jooq.property.CollectionConfig;
import io.dddrive.jooq.property.EnumPropertyImpl;
import io.dddrive.jooq.property.FieldConfig;
import io.dddrive.jooq.property.ReferencePropertyImpl;
import io.dddrive.jooq.property.SimplePropertyImpl;
import io.dddrive.property.model.EnumProperty;
import io.dddrive.property.model.EnumSetProperty;
import io.dddrive.property.model.PartListProperty;
import io.dddrive.property.model.PropertyProvider;
import io.dddrive.property.model.ReferenceProperty;
import io.dddrive.property.model.ReferenceSetProperty;
import io.dddrive.property.model.SimpleProperty;
import io.dddrive.property.model.base.EntityWithPropertiesSPI;
import io.dddrive.property.model.impl.EnumSetPropertyImpl;
import io.dddrive.property.model.impl.PartListPropertyImpl;
import io.dddrive.property.model.impl.ReferenceSetPropertyImpl;
import io.dddrive.util.Invariant;
import java.util.Map;
import org.jooq.Field;
import org.jooq.UpdatableRecord;
import org.jooq.impl.DSL;

public interface PropertyProviderMixin
extends PropertyProvider {
    public void mapProperties();

    public AppContext getAppContext();

    public Map<String, Object> dbConfigMap();

    public UpdatableRecord<?> getDbRecord(EntityWithPropertiesSPI var1, String var2);

    default public void mapField(String name, String tableType, String fieldName, Class<?> fieldType) {
        Invariant.requireThis(this.getFieldConfig(name) == null, "unique field " + name);
        this.dbConfigMap().put(name, new FieldConfig(tableType, fieldName, fieldType));
    }

    default public void mapCollection(String name, String partListTypeName, Class<?> fieldType) {
        Invariant.requireThis(this.getCollectionConfig(name) == null, "unique collection " + name);
        CodePartListType partListType = CodePartListTypeEnum.getPartListType(partListTypeName);
        this.dbConfigMap().put(name, new CollectionConfig(partListType, fieldType));
    }

    @Override
    default public <T> SimpleProperty<T> getSimpleProperty(EntityWithPropertiesSPI entity, String name, Class<T> type) {
        FieldConfig fieldConfig = this.getFieldConfig(name);
        this.checkFieldConfig(fieldConfig, entity, name, type);
        Field field = DSL.field((String)fieldConfig.fieldName(), type);
        UpdatableRecord<?> dbRecord = this.getDbRecord(entity, fieldConfig.tableType());
        return new SimplePropertyImpl(entity, dbRecord, name, field);
    }

    @Override
    default public <E extends Enumerated> EnumProperty<E> getEnumProperty(EntityWithPropertiesSPI entity, String name, Class<E> enumType) {
        FieldConfig fieldConfig = this.getFieldConfig(name);
        this.checkFieldConfig(fieldConfig, entity, name, String.class);
        Field field = DSL.field((String)fieldConfig.fieldName(), String.class);
        Enumeration<E> enumeration = this.getAppContext().getEnumeration(enumType);
        UpdatableRecord<?> dbRecord = this.getDbRecord(entity, fieldConfig.tableType());
        return new EnumPropertyImpl<E>(entity, dbRecord, name, (Field<String>)field, enumeration);
    }

    @Override
    default public <E extends Enumerated> EnumSetProperty<E> getEnumSetProperty(EntityWithPropertiesSPI entity, String name, Class<E> enumType) {
        CollectionConfig collectionConfig = this.getCollectionConfig(name);
        this.checkCollectionConfig(collectionConfig, entity, name, enumType);
        Enumeration<E> enumeration = this.getAppContext().getEnumeration(enumType);
        return new EnumSetPropertyImpl<E>(entity, name, collectionConfig.partListType(), enumeration);
    }

    default public <Aggr extends Aggregate> ReferenceProperty<Aggr> getReferenceProperty(EntityWithPropertiesSPI entity, String name, Class<Aggr> aggregateType) {
        FieldConfig fieldConfig = this.getFieldConfig(name);
        this.checkFieldConfig(fieldConfig, entity, name, Integer.class);
        Field field = DSL.field((String)fieldConfig.fieldName(), Integer.class);
        AggregateCache cache = this.getAppContext().getCache(aggregateType);
        UpdatableRecord<?> dbRecord = this.getDbRecord(entity, fieldConfig.tableType());
        return new ReferencePropertyImpl<Aggregate>(entity, dbRecord, name, (Field<Integer>)field, id -> cache.get(id));
    }

    default public <Aggr extends Aggregate> ReferenceSetProperty<Aggr> getReferenceSetProperty(EntityWithPropertiesSPI entity, String name, Class<Aggr> aggregateType) {
        CollectionConfig collectionConfig = this.getCollectionConfig(name);
        this.checkCollectionConfig(collectionConfig, entity, name, aggregateType);
        AggregateCache cache = this.getAppContext().getCache(aggregateType);
        return new ReferenceSetPropertyImpl<Aggregate>(entity, name, collectionConfig.partListType(), id -> cache.get(id));
    }

    @Override
    default public <P extends Part<?>> PartListProperty<P> getPartListProperty(EntityWithPropertiesSPI entity, String name, Class<P> partType) {
        CollectionConfig collectionConfig = this.getCollectionConfig(name);
        this.checkCollectionConfig(collectionConfig, entity, name, partType);
        return new PartListPropertyImpl<P>(entity, name, collectionConfig.partListType(), partType);
    }

    private FieldConfig getFieldConfig(String name) {
        return (FieldConfig)this.dbConfigMap().get(name);
    }

    private void checkFieldConfig(FieldConfig fieldConfig, EntityWithPropertiesSPI entity, String name, Class<?> type) {
        if (fieldConfig == null) {
            Invariant.assertThis(false, "field [" + name + "] has valid db configuration");
        } else {
            Invariant.assertThis(fieldConfig.fieldType() == type, "field [" + name + "] has matching type");
            UpdatableRecord<?> dbRecord = this.getDbRecord(entity, fieldConfig.tableType());
            Invariant.assertThis(dbRecord.field(fieldConfig.fieldName()) != null, "field [" + name + "/" + fieldConfig.fieldName() + "] contained in database record");
        }
    }

    private CollectionConfig getCollectionConfig(String name) {
        return (CollectionConfig)this.dbConfigMap().get(name);
    }

    private void checkCollectionConfig(CollectionConfig collectionConfig, EntityWithPropertiesSPI entity, String name, Class<?> type) {
        Invariant.assertThis(collectionConfig != null, "field [" + name + "] has valid db configuration");
    }
}

