/*
 * Decompiled with CFR 0.152.
 */
package io.dddrive.jooq.ddd;

import io.dddrive.ddd.model.Aggregate;
import io.dddrive.ddd.model.Part;
import io.dddrive.ddd.model.PartPersistenceProvider;
import io.dddrive.ddd.model.PartPersistenceStatus;
import io.dddrive.ddd.model.PartRepository;
import io.dddrive.ddd.model.base.PartRepositorySPI;
import io.dddrive.jooq.ddd.PartFields;
import io.dddrive.property.model.base.EntityWithPropertiesSPI;
import org.jooq.DSLContext;
import org.jooq.UpdatableRecord;

public interface PartPersistenceProviderMixin<A extends Aggregate, P extends Part<A>>
extends PartPersistenceProvider<A, P> {
    public DSLContext dslContext();

    public PartRepository<A, P> getRepository();

    public UpdatableRecord<?> getDbRecord(EntityWithPropertiesSPI var1);

    @Override
    default public PartPersistenceStatus getPersistenceStatus(Part<?> part) {
        PartRepositorySPI repoSpi = (PartRepositorySPI)((Object)this.getRepository());
        UpdatableRecord<?> dbRecord = this.getDbRecord((EntityWithPropertiesSPI)((Object)part));
        if (part.getMeta().isDeleted()) {
            return PartPersistenceStatus.DELETED;
        }
        if (repoSpi.hasPartId() && dbRecord.changed(PartFields.ID)) {
            return PartPersistenceStatus.CREATED;
        }
        if (dbRecord.changed()) {
            return PartPersistenceStatus.UPDATED;
        }
        return PartPersistenceStatus.READ;
    }

    @Override
    default public void doStore(P part) {
        UpdatableRecord<?> dbRecord = this.getDbRecord((EntityWithPropertiesSPI)part);
        if (this.getPersistenceStatus((Part<?>)part) == PartPersistenceStatus.DELETED) {
            dbRecord.delete();
        } else if (this.getPersistenceStatus((Part<?>)part) != PartPersistenceStatus.READ) {
            dbRecord.store();
        }
    }
}

