/*
 * Decompiled with CFR 0.152.
 */
package io.dddrive.jooq.ddd;

import io.dddrive.ddd.model.Aggregate;
import io.dddrive.ddd.model.Part;
import io.dddrive.ddd.model.PartRepository;
import io.dddrive.ddd.model.base.PartRepositoryBase;
import io.dddrive.ddd.model.base.PartRepositorySPI;
import io.dddrive.ddd.model.base.PartSPI;
import io.dddrive.ddd.model.enums.CodePartListType;
import io.dddrive.jooq.ddd.PartFields;
import io.dddrive.jooq.ddd.PartPersistenceProviderMixin;
import io.dddrive.jooq.ddd.PartState;
import io.dddrive.property.model.base.EntityWithPropertiesSPI;
import io.dddrive.util.Invariant;
import java.util.HashMap;
import java.util.Map;
import org.jooq.DSLContext;
import org.jooq.UpdatableRecord;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class JooqPartRepositoryBase<A extends Aggregate, P extends Part<A>>
extends PartRepositoryBase<A, P>
implements PartPersistenceProviderMixin<A, P> {
    private DSLContext dslContext;
    private final Map<String, Object> dbConfigMap = new HashMap<String, Object>();

    protected JooqPartRepositoryBase(Class<? extends A> aggregateIntfClass, Class<? extends Part<A>> intfClass, Class<? extends Part<A>> baseClass, String partTypeId) {
        super(aggregateIntfClass, intfClass, baseClass, partTypeId);
    }

    @Autowired
    protected void setDSLContext(DSLContext dslContext) {
        this.dslContext = dslContext;
    }

    @Override
    public final Class<? extends Part<A>> getEntityClass() {
        return this.getPartClass();
    }

    public final Map<String, Object> dbConfigMap() {
        return this.dbConfigMap;
    }

    @Override
    public final DSLContext dslContext() {
        return this.dslContext;
    }

    @Override
    public final PartRepository<A, P> getRepository() {
        return this;
    }

    protected final PartRepositorySPI<A, P> getRepositorySPI() {
        return this;
    }

    public final UpdatableRecord<?> getDbRecord(EntityWithPropertiesSPI entity, String tableType) {
        return this.getDbRecord(entity);
    }

    @Override
    public final UpdatableRecord<?> getDbRecord(EntityWithPropertiesSPI entity) {
        Object state = ((PartSPI)((Object)entity)).getPartState();
        return ((PartState)state).dbRecord();
    }

    protected final void doInit(Part<?> part, Integer partId, Part<?> parent, CodePartListType partListType) {
        UpdatableRecord<?> dbRecord = this.getDbRecord((EntityWithPropertiesSPI)((Object)part));
        Invariant.requireThis(!this.hasPartId() || partId != null, "valid id");
        if (this.hasPartId()) {
            dbRecord.setValue(PartFields.ID, (Object)partId);
        }
        dbRecord.setValue(PartFields.PARENT_PART_ID, (Object)(parent != null ? parent.getId() : 0));
        dbRecord.setValue(PartFields.PART_LIST_TYPE_ID, (Object)partListType.getId());
    }
}

