/*
 * Decompiled with CFR 0.152.
 */
package io.dddrive.enums.adapter.api.jsonapi.dto;

import io.crnk.core.resource.annotations.JsonApiId;
import io.dddrive.ddd.model.Aggregate;
import io.dddrive.doc.model.Doc;
import io.dddrive.enums.model.Enumerated;
import io.dddrive.obj.model.Obj;

public class EnumeratedDto {
    @JsonApiId
    private String id;
    private String name;
    private EnumeratedDto itemType;

    public static EnumeratedDto fromEnum(Enumerated e) {
        if (e == null) {
            return null;
        }
        return EnumeratedDto.builder().id(e.getId()).name(e.getName()).build();
    }

    public static EnumeratedDto fromAggregate(Aggregate a) {
        if (a == null) {
            return null;
        }
        return EnumeratedDto.builder().id(a.getId().toString()).itemType(EnumeratedDto.fromEnum(a.getMeta().getAggregateType())).name(a.getCaption()).build();
    }

    public static EnumeratedDto fromObj(Obj obj) {
        return EnumeratedDto.fromAggregate(obj);
    }

    public static EnumeratedDto fromDoc(Doc doc) {
        return EnumeratedDto.fromAggregate(doc);
    }

    public static EnumeratedDtoBuilder builder() {
        return new EnumeratedDtoBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public EnumeratedDto getItemType() {
        return this.itemType;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setItemType(EnumeratedDto itemType) {
        this.itemType = itemType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EnumeratedDto)) {
            return false;
        }
        EnumeratedDto other = (EnumeratedDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        EnumeratedDto this$itemType = this.getItemType();
        EnumeratedDto other$itemType = other.getItemType();
        return !(this$itemType == null ? other$itemType != null : !((Object)this$itemType).equals(other$itemType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EnumeratedDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        EnumeratedDto $itemType = this.getItemType();
        result = result * 59 + ($itemType == null ? 43 : ((Object)$itemType).hashCode());
        return result;
    }

    public String toString() {
        return "EnumeratedDto(id=" + this.getId() + ", name=" + this.getName() + ", itemType=" + String.valueOf(this.getItemType()) + ")";
    }

    public EnumeratedDto() {
    }

    public EnumeratedDto(String id, String name, EnumeratedDto itemType) {
        this.id = id;
        this.name = name;
        this.itemType = itemType;
    }

    public static class EnumeratedDtoBuilder {
        private String id;
        private String name;
        private EnumeratedDto itemType;

        EnumeratedDtoBuilder() {
        }

        public EnumeratedDtoBuilder id(String id) {
            this.id = id;
            return this;
        }

        public EnumeratedDtoBuilder name(String name) {
            this.name = name;
            return this;
        }

        public EnumeratedDtoBuilder itemType(EnumeratedDto itemType) {
            this.itemType = itemType;
            return this;
        }

        public EnumeratedDto build() {
            return new EnumeratedDto(this.id, this.name, this.itemType);
        }

        public String toString() {
            return "EnumeratedDto.EnumeratedDtoBuilder(id=" + this.id + ", name=" + this.name + ", itemType=" + String.valueOf(this.itemType) + ")";
        }
    }
}

