/*
 * Decompiled with CFR 0.152.
 */
package io.dddrive.doc.model.enums;

import io.dddrive.doc.model.enums.CodeCaseDef;
import io.dddrive.doc.model.enums.CodeCaseDefEnum;
import io.dddrive.doc.model.enums.CodeCaseStageEnum;
import io.dddrive.enums.model.base.EnumeratedBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CodeCaseStage
extends EnumeratedBase {
    private final String caseDefId;
    private final Integer seqNr;
    private final String caseStageTypeId;
    private final String description;
    private final String abstractCaseStageId;
    private final String action;
    private final List<String> availableActions;

    public CodeCaseStage(CodeCaseStageEnum enumeration, String id, String caseDefId, String caseStageTypeId, String name, String description, Integer seqNr, String abstractCaseStageId, String action, String availableActions) {
        super(enumeration, id, name);
        this.caseDefId = caseDefId;
        this.seqNr = seqNr;
        this.description = description;
        this.caseStageTypeId = caseStageTypeId;
        this.abstractCaseStageId = abstractCaseStageId;
        this.action = action;
        this.availableActions = availableActions == null ? new ArrayList() : Arrays.asList(availableActions.split(","));
    }

    public CodeCaseDef getCaseDef() {
        return CodeCaseDefEnum.getCaseDef(this.caseDefId);
    }

    public boolean isInWork() {
        return !"terminal".equals(this.caseStageTypeId);
    }

    public Integer getSeqNr() {
        return this.seqNr;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCaseStageTypeId() {
        return this.caseStageTypeId;
    }

    public Boolean getIsAbstract() {
        return this.getCaseStageTypeId().equals("abstract");
    }

    public CodeCaseStage getAbstractCaseStage() {
        return CodeCaseStageEnum.getCaseStage(this.abstractCaseStageId);
    }

    public String getAction() {
        return this.action;
    }

    public List<String> getAvailableActions() {
        return this.availableActions;
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    protected CodeCaseStage(CodeCaseStageBuilder<?, ?> b) {
        super(b);
        this.caseDefId = b.caseDefId;
        this.seqNr = b.seqNr;
        this.caseStageTypeId = b.caseStageTypeId;
        this.description = b.description;
        this.abstractCaseStageId = b.abstractCaseStageId;
        this.action = b.action;
        this.availableActions = b.availableActions;
    }

    public static CodeCaseStageBuilder<?, ?> builder() {
        return new CodeCaseStageBuilderImpl();
    }

    public String getCaseDefId() {
        return this.caseDefId;
    }

    public String getAbstractCaseStageId() {
        return this.abstractCaseStageId;
    }

    @Override
    public String toString() {
        return "CodeCaseStage(caseDefId=" + this.getCaseDefId() + ", seqNr=" + this.getSeqNr() + ", caseStageTypeId=" + this.getCaseStageTypeId() + ", description=" + this.getDescription() + ", abstractCaseStageId=" + this.getAbstractCaseStageId() + ", action=" + this.getAction() + ", availableActions=" + String.valueOf(this.getAvailableActions()) + ")";
    }

    public static abstract class CodeCaseStageBuilder<C extends CodeCaseStage, B extends CodeCaseStageBuilder<C, B>>
    extends EnumeratedBase.EnumeratedBaseBuilder<C, B> {
        private String caseDefId;
        private Integer seqNr;
        private String caseStageTypeId;
        private String description;
        private String abstractCaseStageId;
        private String action;
        private List<String> availableActions;

        public B caseDefId(String caseDefId) {
            this.caseDefId = caseDefId;
            return (B)this.self();
        }

        public B seqNr(Integer seqNr) {
            this.seqNr = seqNr;
            return (B)this.self();
        }

        public B caseStageTypeId(String caseStageTypeId) {
            this.caseStageTypeId = caseStageTypeId;
            return (B)this.self();
        }

        public B description(String description) {
            this.description = description;
            return (B)this.self();
        }

        public B abstractCaseStageId(String abstractCaseStageId) {
            this.abstractCaseStageId = abstractCaseStageId;
            return (B)this.self();
        }

        public B action(String action) {
            this.action = action;
            return (B)this.self();
        }

        public B availableActions(List<String> availableActions) {
            this.availableActions = availableActions;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "CodeCaseStage.CodeCaseStageBuilder(super=" + super.toString() + ", caseDefId=" + this.caseDefId + ", seqNr=" + this.seqNr + ", caseStageTypeId=" + this.caseStageTypeId + ", description=" + this.description + ", abstractCaseStageId=" + this.abstractCaseStageId + ", action=" + this.action + ", availableActions=" + String.valueOf(this.availableActions) + ")";
        }
    }

    private static final class CodeCaseStageBuilderImpl
    extends CodeCaseStageBuilder<CodeCaseStage, CodeCaseStageBuilderImpl> {
        private CodeCaseStageBuilderImpl() {
        }

        @Override
        protected CodeCaseStageBuilderImpl self() {
            return this;
        }

        @Override
        public CodeCaseStage build() {
            return new CodeCaseStage(this);
        }
    }
}

