/*
 * Decompiled with CFR 0.152.
 */
package io.dddrive.ddd.service.api.base;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import io.dddrive.app.event.AggregateStoredEvent;
import io.dddrive.app.service.api.AppContextSPI;
import io.dddrive.ddd.model.Aggregate;
import io.dddrive.ddd.model.AggregateRepository;
import io.dddrive.ddd.service.api.AggregateCache;
import io.dddrive.enums.adapter.api.jsonapi.dto.EnumeratedDto;
import java.util.Map;
import org.springframework.context.event.EventListener;

public abstract class AggregateCacheBase<A extends Aggregate>
implements AggregateCache<A> {
    private final AggregateRepository<? extends A, ?> repository;
    private final Cache<Integer, A> objCache = Caffeine.newBuilder().maximumSize(100L).recordStats().build();
    private final Cache<Integer, EnumeratedDto> enumCache = Caffeine.newBuilder().maximumSize(100L).recordStats().build();
    private int objCacheClear = 0;
    private int enumCacheClear = 0;

    public AggregateCacheBase(AggregateRepository<? extends A, ?> repository, Class<A> aggregateClass) {
        this.repository = repository;
        ((AppContextSPI)((Object)repository.getAppContext())).addCache(aggregateClass, this);
    }

    protected AggregateRepository<? extends A, ?> getRepository() {
        return this.repository;
    }

    @Override
    public A get(Integer id) {
        if (id == null) {
            return null;
        }
        Aggregate aggregate = (Aggregate)this.objCache.get((Object)id, aggrId -> this.repository.get((Integer)aggrId));
        return (A)aggregate;
    }

    @Override
    public EnumeratedDto getAsEnumerated(Integer id) {
        if (id == null) {
            return null;
        }
        EnumeratedDto dto = (EnumeratedDto)this.enumCache.get((Object)id, aggrId -> this.getEnumeratedDto((Integer)aggrId));
        return dto;
    }

    private EnumeratedDto getEnumeratedDto(Integer id) {
        A aggregate = this.get(id);
        return EnumeratedDto.builder().id("" + aggregate.getId()).itemType(EnumeratedDto.fromEnum(this.repository.getAggregateType())).name(aggregate.getCaption()).build();
    }

    public Map<String, Integer> getStatistics() {
        CacheStats objStats = this.objCache.stats();
        CacheStats enumStats = this.enumCache.stats();
        return Map.of("objCacheHit", (int)objStats.hitCount(), "objCacheMiss", (int)objStats.missCount(), "objCacheClear", this.objCacheClear, "enumCacheHit", (int)enumStats.hitCount(), "enumCacheMiss", (int)enumStats.missCount(), "enumCacheClear", this.enumCacheClear);
    }

    @EventListener
    public void handleAggregateStoredEvent(AggregateStoredEvent event) {
        Integer id = event.getAggregate().getId();
        if (this.objCache.getIfPresent((Object)id) != null) {
            ++this.objCacheClear;
            this.objCache.invalidate((Object)id);
        }
        if (this.enumCache.getIfPresent((Object)id) != null) {
            ++this.enumCacheClear;
            this.enumCache.invalidate((Object)id);
        }
    }
}

