/*
 * Decompiled with CFR 0.152.
 */
package io.dddrive.ddd.model.base;

import io.dddrive.app.event.AggregateStoredEvent;
import io.dddrive.app.service.api.AppContext;
import io.dddrive.app.service.api.AppContextSPI;
import io.dddrive.ddd.IdProvider;
import io.dddrive.ddd.model.Aggregate;
import io.dddrive.ddd.model.Part;
import io.dddrive.ddd.model.PartPersistenceProvider;
import io.dddrive.ddd.model.PartPersistenceStatus;
import io.dddrive.ddd.model.PartRepository;
import io.dddrive.ddd.model.base.AggregateBase;
import io.dddrive.ddd.model.base.PartBase;
import io.dddrive.ddd.model.base.PartCache;
import io.dddrive.ddd.model.base.PartRepositorySPI;
import io.dddrive.ddd.model.base.PartSPI;
import io.dddrive.ddd.model.enums.CodePartListType;
import io.dddrive.property.model.PropertyProvider;
import io.dddrive.property.model.impl.PropertyFilter;
import io.dddrive.property.model.impl.PropertyHandler;
import io.dddrive.util.Invariant;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;

public abstract class PartRepositoryBase<A extends Aggregate, P extends Part<A>>
implements PartRepository<A, P>,
PartRepositorySPI<A, P> {
    private final Class<? extends Part<A>> intfClass;
    private AppContext appContext;
    private IdProvider idProvider;
    private final ProxyFactory proxyFactory;
    private final Class<?>[] paramTypeList;

    protected PartRepositoryBase(Class<? extends A> aggregateIntfClass, Class<? extends Part<A>> intfClass, Class<? extends Part<A>> baseClass, String partTypeId) {
        this.intfClass = intfClass;
        this.proxyFactory = new ProxyFactory();
        this.proxyFactory.setSuperclass(baseClass);
        this.proxyFactory.setFilter((MethodFilter)PropertyFilter.INSTANCE);
        this.paramTypeList = new Class[]{PartRepository.class, aggregateIntfClass, Object.class};
    }

    @Autowired
    protected void setAppContext(AppContext appContext) {
        this.appContext = appContext;
        ((AppContextSPI)((Object)this.appContext)).addPartRepository(this.intfClass, this);
    }

    @Override
    public AppContext getAppContext() {
        return this.appContext;
    }

    @Autowired
    protected void setIdProvider(IdProvider idProvider) {
        this.idProvider = idProvider;
    }

    @Override
    public IdProvider getIdProvider() {
        return this.idProvider;
    }

    @Override
    public final PartPersistenceProvider<A, P> getPersistenceProvider() {
        return this.getAppContext().getPartPersistenceProvider(this.intfClass);
    }

    @Override
    public final PropertyProvider getPropertyProvider() {
        return this.getAppContext().getPropertyProvider(this.intfClass);
    }

    protected Class<? extends Part<A>> getPartClass() {
        return this.intfClass;
    }

    @Override
    public boolean hasPartId() {
        return true;
    }

    private final boolean hasPartCache(A aggregate) {
        return ((AggregateBase)aggregate).hasPartCache(this.intfClass);
    }

    @Override
    public final void init(A aggregate) {
        ((AggregateBase)aggregate).initPartCache(this.intfClass);
    }

    private final PartCache<P> getPartCache(A aggregate) {
        return ((AggregateBase)aggregate).getPartCache(this.intfClass);
    }

    @Override
    public final P newPart(A aggregate, Object partState) {
        Part part = null;
        try {
            part = (Part)this.proxyFactory.create((Class[])this.paramTypeList, new Object[]{this, aggregate, partState}, (MethodHandler)PropertyHandler.INSTANCE);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            throw new RuntimeException("could not create part " + this.getClassName());
        }
        return (P)part;
    }

    @Override
    public final P create(A aggregate, CodePartListType partListType) {
        return this.create(aggregate, null, partListType);
    }

    @Override
    public final P create(Part<?> parent, CodePartListType partListType) {
        Object aggregate = parent.getMeta().getAggregate();
        return this.create(aggregate, parent, partListType);
    }

    private P create(A aggregate, Part<?> parent, CodePartListType partListType) {
        Invariant.requireThis(this.hasPartCache(aggregate), this.getClassName() + ": aggregate initialised");
        PartPersistenceProvider<A, P> persistenceProvider = this.getPersistenceProvider();
        Integer partId = this.hasPartId() ? persistenceProvider.nextPartId() : null;
        P p = persistenceProvider.doCreate(aggregate);
        Invariant.assertThis(p != null, "part created");
        if (p == null) {
            return null;
        }
        persistenceProvider.doInit((Part<?>)p, partId, aggregate, parent, partListType);
        Invariant.assertThis(!this.hasPartId() || PartPersistenceStatus.CREATED == p.getMeta().getPersistenceStatus(), "status CREATED");
        p.calcAll();
        this.getPartCache(aggregate).addPart(p);
        Integer doAfterCreateSeqNr = ((PartBase)p).doAfterCreateSeqNr;
        ((PartSPI)p).doAfterCreate();
        Invariant.assertThis(((PartBase)p).doAfterCreateSeqNr > doAfterCreateSeqNr, p.getClass().getSimpleName() + ": doAfterCreate was propagated");
        return p;
    }

    @Override
    public final void load(A aggregate) {
        PartPersistenceProvider<A, P> persistenceProvider = this.getPersistenceProvider();
        List<P> parts = persistenceProvider.doLoad(aggregate);
        parts.forEach(p -> this.getPartCache(aggregate).addPart((Part)p));
        for (Part part : parts) {
            Integer doAssignPartsSeqNr = ((PartBase)part).doAssignPartsSeqNr;
            ((PartSPI)((Object)part)).doAssignParts();
            Invariant.assertThis(((PartBase)part).doAssignPartsSeqNr > doAssignPartsSeqNr, this.getClassName(part) + ": doAssignParts was propagated");
        }
        for (Part part : parts) {
            part.calcVolatile();
        }
        for (Part part : parts) {
            Integer doAfterLoadSeqNr = ((PartBase)part).doAfterLoadSeqNr;
            ((PartSPI)((Object)part)).doAfterLoad();
            Invariant.assertThis(((PartBase)part).doAfterLoadSeqNr > doAfterLoadSeqNr, this.getClassName(part) + ": doAfterLoad was propagated");
        }
    }

    @Override
    public List<P> getParts(A aggregate, CodePartListType partListType) {
        return this.getPartCache(aggregate).getParts().stream().filter(p -> this.isAggregateLevel((Part<?>)p) && partListType.getId().equals(p.getMeta().getPartListTypeId())).toList();
    }

    private boolean isAggregateLevel(Part<?> part) {
        return part.getMeta().getParentPartId() == null || part.getMeta().getParentPartId() == 0;
    }

    @Override
    public List<P> getParts(Part<?> parent, CodePartListType partListType) {
        Object aggregate = parent.getMeta().getAggregate();
        return this.getPartCache(aggregate).getParts().stream().filter(p -> p.getMeta().getParentPartId().equals(parent.getId()) && partListType.getId().equals(p.getMeta().getPartListTypeId())).toList();
    }

    @Override
    public final void store(A aggregate) {
        Invariant.requireThis(this.hasPartCache(aggregate), this.getClassName() + ": aggregate initialised");
        PartPersistenceProvider<A, Part<Object>> persistenceProvider = this.getPersistenceProvider();
        List<P> allParts = this.getPartCache(aggregate).getParts();
        List<Part> activeParts = allParts.stream().filter(p -> p.getMeta().getPersistenceStatus() != PartPersistenceStatus.DELETED).toList();
        for (Part part : activeParts) {
            Integer doBeforeStoreSeqNr = ((PartBase)part).doBeforeStoreSeqNr;
            ((PartSPI)((Object)part)).doBeforeStore();
            Invariant.assertThis(((PartBase)part).doBeforeStoreSeqNr > doBeforeStoreSeqNr, this.getClassName(part) + ": doBeforeStore was propagated");
        }
        for (Part<Object> part : allParts) {
            persistenceProvider.doStore(part);
        }
        for (Part<Object> part : activeParts) {
            Integer doAfterStoreSeqNr = ((PartBase)part).doAfterStoreSeqNr;
            ((PartSPI)((Object)part)).doAfterStore();
            Invariant.assertThis(((PartBase)part).doAfterStoreSeqNr > doAfterStoreSeqNr, this.getClassName(part) + ": doAfterStore was propagated");
        }
    }

    @EventListener
    public void handleAggregateStoredEvent(AggregateStoredEvent event) {
        Aggregate aggregate = event.getAggregate();
        if (this.hasPartCache(aggregate)) {
            this.getPartCache(aggregate).clearParts();
        }
    }

    protected String getClassName() {
        return this.getClass().getSimpleName();
    }

    protected String getClassName(P part) {
        return part.getClass().getSimpleName();
    }
}

