/*
 * Decompiled with CFR 0.152.
 */
package io.dddrive.ddd.model.base;

import io.crnk.core.queryspec.FilterOperator;
import io.crnk.core.queryspec.PathSpec;
import io.crnk.core.queryspec.QuerySpec;
import io.dddrive.app.event.AggregateStoredEvent;
import io.dddrive.app.service.api.AppContext;
import io.dddrive.app.service.api.AppContextSPI;
import io.dddrive.ddd.IdProvider;
import io.dddrive.ddd.model.Aggregate;
import io.dddrive.ddd.model.AggregatePersistenceProvider;
import io.dddrive.ddd.model.AggregateRepository;
import io.dddrive.ddd.model.PartRepository;
import io.dddrive.ddd.model.base.AggregateBase;
import io.dddrive.ddd.model.base.AggregateRepositorySPI;
import io.dddrive.ddd.model.base.AggregateSPI;
import io.dddrive.ddd.model.enums.CodeAggregateType;
import io.dddrive.ddd.model.enums.CodeAggregateTypeEnum;
import io.dddrive.property.model.PropertyProvider;
import io.dddrive.property.model.impl.PropertyFilter;
import io.dddrive.property.model.impl.PropertyHandler;
import io.dddrive.search.service.api.SearchService;
import io.dddrive.util.Invariant;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AggregateRepositoryBase<A extends Aggregate, V>
implements AggregateRepository<A, V>,
AggregateRepositorySPI<A, V> {
    private final Class<? extends Aggregate> intfClass;
    private final String aggregateTypeId;
    private AppContext appContext;
    private IdProvider idProvider;
    private final List<PartRepository<? super A, ?>> partRepositories = new ArrayList();
    private final ProxyFactory proxyFactory;
    private final Class<?>[] proxyFactoryParamTypeList;
    private boolean didAfterCreate = false;
    private boolean didAfterLoad = false;
    private boolean didBeforeStore = false;
    private boolean didAfterStore = false;

    protected AggregateRepositoryBase(Class<? extends AggregateRepository<A, V>> repoIntfClass, Class<? extends Aggregate> intfClass, Class<? extends Aggregate> baseClass, String aggregateTypeId) {
        this.intfClass = intfClass;
        this.aggregateTypeId = aggregateTypeId;
        this.proxyFactory = new ProxyFactory();
        this.proxyFactory.setSuperclass(baseClass);
        this.proxyFactory.setFilter((MethodFilter)PropertyFilter.INSTANCE);
        this.proxyFactoryParamTypeList = new Class[]{repoIntfClass, Object.class};
    }

    @Autowired
    protected void setAppContext(AppContext appContext) {
        this.appContext = appContext;
        ((AppContextSPI)((Object)this.appContext)).addRepository(this.intfClass, this);
    }

    @Autowired
    protected void setIdProvider(IdProvider idProvider) {
        this.idProvider = idProvider;
    }

    @Override
    public IdProvider getIdProvider() {
        return this.idProvider;
    }

    public final AggregateRepositorySPI<A, V> repositorySPI() {
        return this;
    }

    @Override
    public final AggregatePersistenceProvider<A> getPersistenceProvider() {
        return this.appContext.getAggregatePersistenceProvider(this.intfClass);
    }

    @Override
    public final PropertyProvider getPropertyProvider() {
        return this.appContext.getPropertyProvider(this.intfClass);
    }

    @Override
    public final Class<A> getAggregateClass() {
        return this.intfClass;
    }

    @Override
    public final CodeAggregateType getAggregateType() {
        return CodeAggregateTypeEnum.getAggregateType(this.aggregateTypeId);
    }

    @Override
    public final AppContext getAppContext() {
        return this.appContext;
    }

    protected void addPartRepository(PartRepository<? super A, ?> partRepository) {
        Invariant.requireThis(partRepository != null, "partRepository is not null");
        this.partRepositories.add(partRepository);
    }

    @Override
    public final A newAggregate(Object state) {
        Aggregate aggregate = null;
        try {
            Object[] params = new Object[]{this, state};
            aggregate = (Aggregate)this.proxyFactory.create((Class[])this.proxyFactoryParamTypeList, params, (MethodHandler)PropertyHandler.INSTANCE);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            throw new RuntimeException(this.getClassName() + ": could not create aggregate");
        }
        return (A)aggregate;
    }

    @Override
    public final A create(Integer tenantId) {
        AggregatePersistenceProvider<A> persistenceProvider = this.getPersistenceProvider();
        Integer aggregateId = persistenceProvider.nextAggregateId();
        A aggregate = persistenceProvider.doCreate();
        ((AggregateBase)aggregate).unfreeze();
        Integer doInitSeqNr = ((AggregateBase)aggregate).doInitSeqNr;
        ((AggregateSPI)aggregate).doInit(aggregateId, tenantId);
        Invariant.assertThis(((AggregateBase)aggregate).doInitSeqNr > doInitSeqNr, this.getClassName(aggregate) + ": doInit was propagated");
        this.doInitParts(aggregate);
        aggregate.calcAll();
        this.didAfterCreate = false;
        this.doAfterCreate(aggregate);
        Invariant.assertThis(this.didAfterCreate, this.getClassName() + ": doAfterCreate was propagated");
        return aggregate;
    }

    @Override
    public final void doInitParts(A aggregate) {
        for (PartRepository<A, ?> partRepo : this.partRepositories) {
            partRepo.init(aggregate);
        }
    }

    @Override
    public void doAfterCreate(A aggregate) {
        this.didAfterCreate = true;
        Integer doAfterCreateSeqNr = ((AggregateBase)aggregate).doAfterCreateSeqNr;
        ((AggregateSPI)aggregate).doAfterCreate();
        Invariant.assertThis(((AggregateBase)aggregate).doAfterCreateSeqNr > doAfterCreateSeqNr, this.getClassName(aggregate) + ": doAfterCreate was propagated");
    }

    @Override
    public final A get(Integer id) {
        return this.get(id, true);
    }

    @Override
    public final A load(Integer id) {
        return this.get(id, false);
    }

    private A get(Integer id, boolean isFrozen) {
        Invariant.requireThis(id != null, "id not null");
        AggregatePersistenceProvider<A> persistenceProvider = this.getPersistenceProvider();
        A aggregate = persistenceProvider.doLoad(id);
        ((AggregateBase)aggregate).unfreeze();
        this.doInitParts(aggregate);
        this.doLoadParts(aggregate);
        Integer doAssignPartsSeqNr = ((AggregateBase)aggregate).doAssignPartsSeqNr;
        ((AggregateSPI)aggregate).doAssignParts();
        Invariant.assertThis(((AggregateBase)aggregate).doAssignPartsSeqNr > doAssignPartsSeqNr, this.getClassName(aggregate) + ": doAssignParts was propagated");
        aggregate.calcVolatile();
        this.didAfterLoad = false;
        this.doAfterLoad(aggregate);
        Invariant.assertThis(this.didAfterLoad, this.getClassName() + ": doAfterLoad was propagated");
        if (isFrozen) {
            ((AggregateBase)aggregate).freeze();
        }
        return aggregate;
    }

    @Override
    public final void doLoadParts(A aggregate) {
        ArrayList repos = new ArrayList(this.partRepositories);
        Collections.reverse(repos);
        for (PartRepository partRepository : repos) {
            partRepository.load(aggregate);
        }
    }

    @Override
    public void doAfterLoad(A aggregate) {
        this.didAfterLoad = true;
        Integer doAfterLoadSeqNr = ((AggregateBase)aggregate).doAfterLoadSeqNr;
        ((AggregateSPI)aggregate).doAfterLoad();
        Invariant.assertThis(((AggregateBase)aggregate).doAfterLoadSeqNr > doAfterLoadSeqNr, this.getClassName(aggregate) + ": doAfterLoad was propagated");
    }

    @Override
    public final void store(A aggregate) {
        this.didBeforeStore = false;
        this.doBeforeStore(aggregate);
        Invariant.assertThis(this.didBeforeStore, this.getClassName() + ": doBeforeStore was propagated");
        this.getPersistenceProvider().doStore(aggregate);
        this.doStoreParts(aggregate);
        this.storeSearch(aggregate);
        this.didAfterStore = false;
        this.doAfterStore(aggregate);
        Invariant.assertThis(this.didAfterStore, this.getClassName() + ": doAfterStore was propagated");
    }

    @Override
    public void doBeforeStore(A aggregate) {
        this.didBeforeStore = true;
        Integer doBeforeStoreSeqNr = ((AggregateBase)aggregate).doBeforeStoreSeqNr;
        ((AggregateSPI)aggregate).doBeforeStore();
        Invariant.assertThis(((AggregateBase)aggregate).doBeforeStoreSeqNr > doBeforeStoreSeqNr, this.getClassName(aggregate) + ": doBeforeStore was propagated");
    }

    @Override
    public final void doStoreParts(A aggregate) {
        for (PartRepository<A, ?> partRepo : this.partRepositories) {
            partRepo.store(aggregate);
        }
    }

    private final void storeSearch(A aggregate) {
        ((AggregateBase)aggregate).doStoreSearch();
    }

    protected final void storeSearch(Aggregate aggregate, List<String> texts, List<String> tokens) {
        this.appContext.getBean(SearchService.class).storeSearch(aggregate, texts, tokens);
    }

    @Override
    public void doAfterStore(A aggregate) {
        this.didAfterStore = true;
        Integer doAfterStoreSeqNr = ((AggregateBase)aggregate).doAfterStoreSeqNr;
        ((AggregateSPI)aggregate).doAfterStore();
        Invariant.assertThis(((AggregateBase)aggregate).doAfterStoreSeqNr > doAfterStoreSeqNr, this.getClassName(aggregate) + ": doAfterStore was propagated");
        AggregateStoredEvent aggregateStoredEvent = new AggregateStoredEvent(aggregate, (Aggregate)aggregate);
        this.appContext.publishApplicationEvent(aggregateStoredEvent);
    }

    @Override
    public abstract List<V> doFind(QuerySpec var1);

    @Override
    public final List<V> getByForeignKey(String fkName, Integer targetId) {
        QuerySpec querySpec = new QuerySpec(Aggregate.class);
        querySpec.addFilter(PathSpec.of((String)fkName).filter(FilterOperator.EQ, (Object)targetId));
        return this.find(querySpec);
    }

    protected String getClassName() {
        return this.getClass().getSimpleName();
    }

    protected String getClassName(A aggregate) {
        return aggregate.getClass().getSuperclass().getSimpleName();
    }
}

