/*
 * Decompiled with CFR 0.152.
 */
package io.dddrive.ddd.model.base;

import io.dddrive.app.service.api.AppContext;
import io.dddrive.ddd.model.Aggregate;
import io.dddrive.ddd.model.AggregateMeta;
import io.dddrive.ddd.model.AggregateRepository;
import io.dddrive.ddd.model.Part;
import io.dddrive.ddd.model.PartRepository;
import io.dddrive.ddd.model.base.AggregateRepositoryBase;
import io.dddrive.ddd.model.base.AggregateRepositorySPI;
import io.dddrive.ddd.model.base.AggregateSPI;
import io.dddrive.ddd.model.base.PartCache;
import io.dddrive.ddd.model.enums.CodePartListType;
import io.dddrive.property.model.PartListProperty;
import io.dddrive.property.model.Property;
import io.dddrive.property.model.PropertyProvider;
import io.dddrive.property.model.base.EntityWithPropertiesBase;
import io.dddrive.util.Invariant;
import io.dddrive.validation.model.AggregatePartValidation;
import io.dddrive.validation.model.enums.CodeValidationLevel;
import io.dddrive.validation.model.impl.AggregatePartValidationImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AggregateBase
extends EntityWithPropertiesBase
implements Aggregate,
AggregateMeta,
AggregateSPI {
    private final AggregateRepository<? extends Aggregate, ? extends Object> repository;
    private final Object state;
    private Map<Class<? extends Part<?>>, PartCache<?>> partCaches = new ConcurrentHashMap();
    private boolean isFrozen = true;
    private int isCalcDisabled = 0;
    private boolean isInCalc = false;
    private List<AggregatePartValidation> validations = new ArrayList<AggregatePartValidation>();
    private boolean didCalcAll = false;
    private boolean didCalcVolatile = false;
    protected Integer doInitSeqNr = 0;
    protected Integer doAfterCreateSeqNr = 0;
    protected Integer doAssignPartsSeqNr = 0;
    protected Integer doAfterLoadSeqNr = 0;
    protected Integer doBeforeStoreSeqNr = 0;
    protected Integer doAfterStoreSeqNr = 0;
    private List<String> searchTexts = new ArrayList<String>();
    private List<String> searchTokens = new ArrayList<String>();

    protected AggregateBase(AggregateRepository<? extends Aggregate, ? extends Object> repository, Object state) {
        this.repository = repository;
        this.state = state;
    }

    @Override
    public AppContext getAppContext() {
        return this.repository.getAppContext();
    }

    public AggregateRepository<? extends Aggregate, ? extends Object> getRepository() {
        return this.repository;
    }

    @Override
    public Object getAggregateState() {
        return this.state;
    }

    @Override
    public AggregateMeta getMeta() {
        return this;
    }

    @Override
    public final PropertyProvider getPropertyProvider() {
        if (this.getRepository() != null) {
            return ((AggregateRepositorySPI)((Object)this.getRepository())).getPropertyProvider();
        }
        return null;
    }

    public boolean hasPartCache(Class<? extends Part<?>> clazz) {
        return this.partCaches.containsKey(clazz);
    }

    public void initPartCache(Class<? extends Part<?>> clazz) {
        Invariant.requireThis(!this.hasPartCache(clazz), "aggregate not yet initialised");
        this.partCaches.put(clazz, new PartCache());
    }

    public PartCache<?> getPartCache(Class<? extends Part<?>> clazz) {
        Invariant.requireThis(this.hasPartCache(clazz), "part cache for " + clazz.getSimpleName() + " initialised (did you forget to registerPartRepositories() in repository?)");
        return this.partCaches.get(clazz);
    }

    @Override
    public void doInit(Integer aggregateId, Integer tenantId) {
        this.doInitSeqNr = this.doInitSeqNr + 1;
    }

    @Override
    public void doAfterCreate() {
        this.doAfterCreateSeqNr = this.doAfterCreateSeqNr + 1;
    }

    @Override
    public void doAssignParts() {
        this.doAssignPartsSeqNr = this.doAssignPartsSeqNr + 1;
        for (Property<?> property : this.getProperties()) {
            if (!(property instanceof PartListProperty)) continue;
            PartListProperty partListProperty = (PartListProperty)property;
            this.assignPartListParts(partListProperty, partListProperty.getPartListType());
        }
    }

    private <A extends Aggregate, P extends Part<A>> void assignPartListParts(PartListProperty<?> property, CodePartListType partListType) {
        Class<?> partType = property.getPartType();
        PartRepository<AggregateBase, ?> partRepository = this.getAppContext().getPartRepository(partType);
        List<?> partList = partRepository.getParts(this, partListType);
        property.loadParts(partList);
    }

    @Override
    public void doAfterLoad() {
        this.doAfterLoadSeqNr = this.doAfterLoadSeqNr + 1;
    }

    @Override
    public void doBeforeStore() {
        this.doBeforeStoreSeqNr = this.doBeforeStoreSeqNr + 1;
        this.doBeforeStoreProperties();
    }

    protected void doStoreSearch() {
        this.searchTexts.clear();
        this.searchTokens.clear();
        this.doCalcSearch();
        ((AggregateRepositoryBase)this.getRepository()).storeSearch(this, this.searchTexts, this.searchTokens);
    }

    protected void addSearchText(String text) {
        this.searchTexts.add(text);
    }

    protected void addSearchToken(String token) {
        this.searchTokens.add(token);
    }

    @Override
    public abstract void doCalcSearch();

    @Override
    public void doAfterStore() {
        this.doAfterStoreSeqNr = this.doAfterStoreSeqNr + 1;
    }

    @Override
    public boolean isFrozen() {
        return this.isFrozen;
    }

    protected void unfreeze() {
        this.isFrozen = false;
    }

    protected void freeze() {
        this.isFrozen = true;
    }

    @Override
    public Part<?> addPart(Property<?> property, CodePartListType partListType) {
        if (property instanceof PartListProperty) {
            return this.addPartListPart(property, partListType);
        }
        Invariant.assertThis(false, "could instantiate part for property " + property.getName() + " (" + partListType.getId() + ", " + property.getClass().getSimpleName() + ")");
        return null;
    }

    private <A extends Aggregate, P extends Part<A>> Part<A> addPartListPart(Property<?> property, CodePartListType partListType) {
        Class partType = ((PartListProperty)property).getPartType();
        PartRepository partRepository = this.getAppContext().getPartRepository(partType);
        return partRepository.create(this, partListType);
    }

    @Override
    public void afterSet(Property<?> property) {
        this.calcAll();
    }

    @Override
    public void afterAdd(Property<?> property) {
        this.calcAll();
    }

    @Override
    public void afterRemove(Property<?> property) {
        this.calcAll();
    }

    @Override
    public void afterClear(Property<?> property) {
        this.calcAll();
    }

    private void clearValidationList() {
        this.validations.clear();
    }

    @Override
    public List<AggregatePartValidation> getValidations() {
        return List.copyOf(this.validations);
    }

    protected void addValidation(CodeValidationLevel validationLevel, String validation) {
        this.validations.add(AggregatePartValidationImpl.builder().seqNr(this.validations.size()).validationLevel(validationLevel).validation(validation).build());
    }

    @Override
    public boolean isCalcEnabled() {
        return this.isCalcDisabled == 0;
    }

    @Override
    public void disableCalc() {
        ++this.isCalcDisabled;
    }

    @Override
    public void enableCalc() {
        --this.isCalcDisabled;
    }

    protected boolean isInCalc() {
        return this.isInCalc;
    }

    protected void beginCalc() {
        this.isInCalc = true;
        this.didCalcAll = false;
        this.didCalcVolatile = false;
    }

    protected void endCalc() {
        this.isInCalc = false;
    }

    @Override
    public void calcAll() {
        if (!this.isCalcEnabled() || this.isInCalc()) {
            return;
        }
        try {
            this.beginCalc();
            this.clearValidationList();
            this.doCalcAll();
            Invariant.assertThis(this.didCalcAll, this.getClass().getSimpleName() + ": doCalcAll was propagated");
        }
        finally {
            this.endCalc();
        }
    }

    protected void doCalcAll() {
        this.didCalcAll = true;
    }

    @Override
    public void calcVolatile() {
        if (!this.isCalcEnabled() || this.isInCalc()) {
            return;
        }
        try {
            this.beginCalc();
            this.doCalcVolatile();
            Invariant.assertThis(this.didCalcVolatile, this.getClass().getSimpleName() + ": doCalcAll was propagated");
        }
        finally {
            this.endCalc();
        }
    }

    protected void doCalcVolatile() {
        this.didCalcVolatile = true;
    }
}

