/*
 * Decompiled with CFR 0.152.
 */
package io.dddrive.ddd.adapter.api.jsonapi.base;

import io.crnk.core.engine.document.ErrorData;
import io.crnk.core.engine.document.ErrorDataBuilder;
import io.crnk.core.exception.BadRequestException;
import io.crnk.core.exception.ResourceNotFoundException;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.repository.ResourceRepositoryBase;
import io.crnk.core.resource.list.DefaultResourceList;
import io.crnk.core.resource.list.ResourceList;
import io.dddrive.app.model.RequestContext;
import io.dddrive.ddd.adapter.api.jsonapi.dto.AggregateDtoAdapterBase;
import io.dddrive.ddd.adapter.api.jsonapi.dto.AggregateDtoBase;
import io.dddrive.ddd.model.Aggregate;
import io.dddrive.ddd.model.AggregateRepository;
import io.dddrive.obj.model.Obj;
import io.dddrive.oe.service.api.ObjUserCache;
import java.util.List;
import org.springframework.transaction.annotation.Transactional;

public abstract class AggregateApiRepositoryBase<A extends Aggregate, V, D extends AggregateDtoBase<A>>
extends ResourceRepositoryBase<D, Integer> {
    private final RequestContext requestCtx;
    private final ObjUserCache userCache;
    private final AggregateRepository<A, V> repository;
    private final AggregateDtoAdapterBase<A, V, D> dtoAdapter;

    public AggregateApiRepositoryBase(Class<D> dtoClass, RequestContext requestCtx, ObjUserCache userCache, AggregateRepository<A, V> repository, AggregateDtoAdapterBase<A, V, D> dtoAdapter) {
        super(dtoClass);
        this.requestCtx = requestCtx;
        this.userCache = userCache;
        this.repository = repository;
        this.dtoAdapter = dtoAdapter;
    }

    @Transactional
    public <S extends D> S create(S dto) {
        if (((AggregateDtoBase)dto).getId() != null) {
            throw new BadRequestException("Cannot specify id on creation (" + ((AggregateDtoBase)dto).getId() + ")");
        }
        try {
            this.userCache.touch(this.requestCtx.getUser().getId());
            Integer tenantId = ((AggregateDtoBase)dto).getTenant() != null ? Integer.parseInt(((AggregateDtoBase)dto).getTenant().getId()) : this.requestCtx.getTenantId();
            A aggregate = this.repository.create(tenantId);
            this.dtoAdapter.toAggregate(dto, aggregate);
            this.repository.store(aggregate);
            return (S)this.dtoAdapter.fromAggregate(aggregate);
        }
        catch (Exception x) {
            throw new RuntimeException("crashed on create", x);
        }
    }

    @Transactional
    public D findOne(Integer objId, QuerySpec querySpec) {
        try {
            this.userCache.touch(this.requestCtx.getUser().getId());
            A aggregate = this.repository.load(objId);
            this.requestCtx.addAggregate((Aggregate)aggregate);
            return this.dtoAdapter.fromAggregate(aggregate);
        }
        catch (Exception x) {
            throw new ResourceNotFoundException(this.repository.getAggregateType().getName() + "[" + objId + "]");
        }
    }

    @Transactional
    public ResourceList<D> findAll(QuerySpec querySpec) {
        try {
            this.userCache.touch(this.requestCtx.getUser().getId());
            List<V> itemList = this.repository.find(querySpec);
            DefaultResourceList list = new DefaultResourceList();
            list.addAll(itemList.stream().map(item -> this.dtoAdapter.fromRecord(item)).toList());
            return list;
        }
        catch (Exception x) {
            throw new RuntimeException("crashed on findAll", x);
        }
    }

    @Transactional
    public <S extends D> S save(S dto) {
        this.userCache.touch(this.requestCtx.getUser().getId());
        if (((AggregateDtoBase)dto).getId() == null) {
            throw new BadRequestException("Can only save existing object (missing id)");
        }
        if (((AggregateDtoBase)dto).getMeta() == null) {
            throw new BadRequestException("Missing meta information (version or operation)");
        }
        if (((AggregateDtoBase)dto).getMeta().getClientVersion() == null && !((AggregateDtoBase)dto).getMeta().hasOperation("calculationOnly")) {
            throw new BadRequestException("Missing meta information (version or operation)");
        }
        try {
            Aggregate aggregate;
            Aggregate aggregate2 = aggregate = this.requestCtx.hasAggregate(((AggregateDtoBase)dto).getId()) ? this.requestCtx.getAggregate(((AggregateDtoBase)dto).getId()) : this.repository.load(((AggregateDtoBase)dto).getId());
            if (((AggregateDtoBase)dto).getMeta().hasOperation("calculationOnly")) {
                this.dtoAdapter.toAggregate(dto, aggregate);
            } else {
                if (((AggregateDtoBase)dto).getMeta().getClientVersion() == null) {
                    throw new BadRequestException("Missing version");
                }
                if (((AggregateDtoBase)dto).getMeta().getClientVersion().intValue() != aggregate.getMeta().getVersion().intValue()) {
                    ErrorData errorData = new ErrorDataBuilder().setStatus("409").setTitle("Fehler beim Speichern").setDetail("Sie versuchten eine veraltete Version zu speichern. Benutzer " + aggregate.getMeta().getModifiedByUser().getCaption() + " hat das Objekt in der Zwischenzeit bereits ge\u00e4ndert. Ihre \u00c4nderungen wurden verworfen und die aktuelle Version geladen.").build();
                    throw new BadRequestException(409, errorData);
                }
                this.dtoAdapter.toAggregate(dto, aggregate);
                this.repository.store(aggregate);
                aggregate = this.repository.get(((AggregateDtoBase)dto).getId());
            }
            return (S)this.dtoAdapter.fromAggregate(aggregate);
        }
        catch (Exception x) {
            throw new RuntimeException("crashed on save", x);
        }
    }

    @Transactional
    public void delete(Integer id) {
        this.userCache.touch(this.requestCtx.getUser().getId());
        if (id == null) {
            throw new ResourceNotFoundException("Can only delete existing object (missing id)");
        }
        try {
            Aggregate aggregate;
            Aggregate aggregate2 = aggregate = this.requestCtx.hasAggregate(id) ? this.requestCtx.getAggregate(id) : this.repository.load(id);
            if (!(aggregate instanceof Obj)) {
                throw new BadRequestException("Can only delete an Object");
            }
            ((Obj)aggregate).delete();
            this.repository.store(aggregate);
        }
        catch (Exception x) {
            throw new RuntimeException("crashed on delete", x);
        }
    }
}

