/*
 * Decompiled with CFR 0.152.
 */
package io.dddrive.app.service.api.impl;

import io.dddrive.ddd.model.Aggregate;
import io.dddrive.ddd.model.AggregateRepository;
import io.dddrive.ddd.model.Part;
import io.dddrive.ddd.model.PartRepository;
import io.dddrive.util.Invariant;
import java.util.HashMap;
import java.util.Map;

public final class Repositories {
    private Map<Class<? extends Aggregate>, AggregateRepository<?, ?>> repoByIntf = new HashMap();
    private Map<Class<? extends Part<?>>, PartRepository<?, ?>> partRepoByIntf = new HashMap();

    public void addRepository(Class<? extends Aggregate> intfClass, AggregateRepository<?, ?> repo) {
        Invariant.assertThis(this.getRepository(intfClass) == null, "unique repo for class " + String.valueOf(intfClass));
        this.repoByIntf.put(intfClass, repo);
    }

    public <A extends Aggregate> AggregateRepository<A, ?> getRepository(Class<A> intfClass) {
        return this.repoByIntf.get(intfClass);
    }

    public void addPartRepository(Class<? extends Part<?>> intfClass, PartRepository<?, ?> repo) {
        Invariant.assertThis(this.getPartRepository(intfClass) == null, "unique repo for class " + String.valueOf(intfClass));
        this.partRepoByIntf.put(intfClass, repo);
    }

    public <A extends Aggregate, P extends Part<A>> PartRepository<A, P> getPartRepository(Class<? extends Part<?>> intfClass) {
        return this.partRepoByIntf.get(intfClass);
    }
}

