/*
 * Decompiled with CFR 0.152.
 */
package io.dddrive.app.service.api.impl;

import io.dddrive.enums.model.Enumerated;
import io.dddrive.enums.model.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service(value="enumerations")
public final class Enumerations {
    private Map<String, Enumeration<? extends Enumerated>> enumsById = new HashMap<String, Enumeration<? extends Enumerated>>();
    private Map<Class<? extends Enumerated>, Enumeration<? extends Enumerated>> enumsByEnumeratedClass = new HashMap<Class<? extends Enumerated>, Enumeration<? extends Enumerated>>();
    private Map<Class<? extends Enumeration<?>>, Enumeration<? extends Enumerated>> enumsByEnumerationClass = new HashMap();

    public <E extends Enumerated> void addEnumeration(Class<E> enumeratedClass, Enumeration<E> e) {
        this.enumsById.put(e.getModule() + "." + e.getId(), e);
        this.enumsByEnumerationClass.put(e.getClass(), e);
        this.enumsByEnumeratedClass.put(enumeratedClass, e);
    }

    public Enumeration<? extends Enumerated> getEnumeration(String module, String name) {
        return this.enumsById.get(module + "." + name + "Enum");
    }

    public <E extends Enumerated> Enumeration<E> getEnumeration(Class<E> enumClass) {
        return this.enumsByEnumeratedClass.get(enumClass);
    }
}

