/*
 * Decompiled with CFR 0.152.
 */
package io.dddrive.app.model.base;

import io.dddrive.app.model.RequestContext;
import io.dddrive.ddd.model.Aggregate;
import io.dddrive.oe.model.ObjUser;
import io.dddrive.oe.model.enums.CodeLocale;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class RequestContextBase
implements RequestContext {
    private final ObjUser user;
    private final Integer tenantId;
    private final CodeLocale locale;
    private final Map<Integer, Aggregate> aggregates = new ConcurrentHashMap<Integer, Aggregate>();

    @Override
    public boolean hasAggregate(Integer id) {
        return this.aggregates.containsKey(id);
    }

    @Override
    public Aggregate getAggregate(Integer id) {
        return this.aggregates.get(id);
    }

    @Override
    public void addAggregate(Aggregate aggregate) {
        this.aggregates.put(aggregate.getId(), aggregate);
    }

    @Override
    public LocalDate getCurrentDate() {
        return LocalDate.now();
    }

    @Override
    public OffsetDateTime getCurrentTime() {
        return OffsetDateTime.now();
    }

    protected RequestContextBase(RequestContextBaseBuilder<?, ?> b) {
        this.user = b.user;
        this.tenantId = b.tenantId;
        this.locale = b.locale;
    }

    @Override
    public ObjUser getUser() {
        return this.user;
    }

    @Override
    public Integer getTenantId() {
        return this.tenantId;
    }

    @Override
    public CodeLocale getLocale() {
        return this.locale;
    }

    public Map<Integer, Aggregate> getAggregates() {
        return this.aggregates;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestContextBase)) {
            return false;
        }
        RequestContextBase other = (RequestContextBase)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$tenantId = this.getTenantId();
        Integer other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        ObjUser this$user = this.getUser();
        ObjUser other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        CodeLocale this$locale = this.getLocale();
        CodeLocale other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !((Object)this$locale).equals(other$locale)) {
            return false;
        }
        Map<Integer, Aggregate> this$aggregates = this.getAggregates();
        Map<Integer, Aggregate> other$aggregates = other.getAggregates();
        return !(this$aggregates == null ? other$aggregates != null : !((Object)this$aggregates).equals(other$aggregates));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RequestContextBase;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        ObjUser $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        CodeLocale $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : ((Object)$locale).hashCode());
        Map<Integer, Aggregate> $aggregates = this.getAggregates();
        result = result * 59 + ($aggregates == null ? 43 : ((Object)$aggregates).hashCode());
        return result;
    }

    public String toString() {
        return "RequestContextBase(user=" + String.valueOf(this.getUser()) + ", tenantId=" + this.getTenantId() + ", locale=" + String.valueOf(this.getLocale()) + ", aggregates=" + String.valueOf(this.getAggregates()) + ")";
    }

    public static abstract class RequestContextBaseBuilder<C extends RequestContextBase, B extends RequestContextBaseBuilder<C, B>> {
        private ObjUser user;
        private Integer tenantId;
        private CodeLocale locale;

        public B user(ObjUser user) {
            this.user = user;
            return this.self();
        }

        public B tenantId(Integer tenantId) {
            this.tenantId = tenantId;
            return this.self();
        }

        public B locale(CodeLocale locale) {
            this.locale = locale;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "RequestContextBase.RequestContextBaseBuilder(user=" + String.valueOf(this.user) + ", tenantId=" + this.tenantId + ", locale=" + String.valueOf(this.locale) + ")";
        }
    }
}

