
package io.dddrive.oe.model.enums;

import org.springframework.stereotype.Component;

import io.dddrive.app.service.api.impl.Enumerations;
import io.dddrive.enums.model.base.EnumerationBase;

@Component("codeUserRoleEnum")
public class CodeUserRoleEnum extends EnumerationBase<CodeUserRole> {

	// normal user, needs account (so either in advisor or community tenant)
	public static CodeUserRole USER;
	// elevated user, needs account (so either in advisor or community tenant)
	public static CodeUserRole SUPER_USER;
	// read-only user, needs account (so either in advisor or community tenant)
	public static CodeUserRole READ_ONLY;

	// admin for a advisor or community tenant (1 tenant, n users, 1 .. n accounts)
	// login to advisor or community tenant, without account
	public static CodeUserRole ADMIN;
	// admin for a advisor or community tenant (tenants, users, accounts)
	// login to kernel tenant only, without account
	public static CodeUserRole APP_ADMIN;

	private static CodeUserRoleEnum INSTANCE;

	protected CodeUserRoleEnum(Enumerations enums) {
		super(CodeUserRole.class, enums);
		INSTANCE = this;
	}

	public static CodeUserRoleEnum getInstance() {
		return INSTANCE;
	}

	public void addItem(CodeUserRole item) {
		super.addItem(item);
	}

	public void init() {
		USER = getUserRole("user");
		SUPER_USER = getUserRole("super_user");
		READ_ONLY = getUserRole("read_only");
		ADMIN = getUserRole("admin");
		APP_ADMIN = getUserRole("app_admin");
	}

	public static CodeUserRole getUserRole(String userRoleId) {
		return INSTANCE.getItem(userRoleId);
	}

}
