package io.dddrive.jooq.property;

import static io.dddrive.util.Invariant.requireThis;

import java.util.Objects;

import org.jooq.Field;
import org.jooq.UpdatableRecord;

import io.dddrive.property.model.SimpleProperty;
import io.dddrive.property.model.base.EntityWithPropertiesSPI;
import io.dddrive.property.model.base.PropertyBase;

public class SimplePropertyImpl<T> extends PropertyBase<T> implements SimpleProperty<T> {

	private final UpdatableRecord<?> dbRecord;
	private final String fieldName;
	private final Field<T> field;

	public SimplePropertyImpl(EntityWithPropertiesSPI entity, UpdatableRecord<?> dbRecord, String fieldName,
			Field<T> field) {
		super(entity);
		this.dbRecord = dbRecord;
		this.fieldName = fieldName;
		this.field = field;
	}

	@Override
	public String getName() {
		return this.fieldName;
	}

	@Override
	public T getValue() {
		return this.dbRecord.getValue(this.field);
	}

	@Override
	public void setValue(T value) {
		requireThis(this.isWritable(), "not frozen");
		if (Objects.equals(this.getValue(), value)) {
			return;
		}
		this.dbRecord.setValue(this.field, value);
		this.getEntity().afterSet(this);
	}

}
