package io.dddrive.jooq.doc;

import java.util.HashMap;
import java.util.Map;

import javax.annotation.PostConstruct;

import org.jooq.DSLContext;
import org.jooq.TableRecord;
import org.springframework.beans.factory.annotation.Autowired;

import io.dddrive.ddd.model.Aggregate;
import io.dddrive.ddd.model.AggregateRepository;
import io.dddrive.doc.model.Doc;
import io.dddrive.doc.model.base.DocRepositoryBase;
import io.dddrive.jooq.util.SqlUtils;
import io.dddrive.jooq.util.SqlUtils.SearchConditionProvider;

public abstract class JooqDocExtnRepositoryBase<D extends Doc, V extends TableRecord<?>>
		extends DocRepositoryBase<D, V>
		implements DocExtnPropertyProviderMixin {

	private DSLContext dslContext;
	private SqlUtils sqlUtils;
	private final Map<String, Object> dbConfigMap = new HashMap<>();

	public JooqDocExtnRepositoryBase(
			Class<? extends AggregateRepository<D, V>> repoIntfClass,
			Class<? extends Doc> intfClass,
			Class<? extends Doc> baseClass,
			String aggregateTypeId) {
		super(repoIntfClass, intfClass, baseClass, aggregateTypeId);
	}

	@PostConstruct
	protected void init() {
		this.mapProperties();
	}

	@Autowired
	protected void setDSLContext(DSLContext dslContext) {
		this.dslContext = dslContext;
	}

	@Autowired
	protected void setSearchConditionProvider(SearchConditionProvider searchConditionProvider) {
		this.sqlUtils = new SqlUtils(searchConditionProvider);
	}

	@Override
	public final Class<? extends Aggregate> getEntityClass() {
		return this.getAggregateClass();
	}

	@Override
	public final Map<String, Object> dbConfigMap() {
		return this.dbConfigMap;
	}

	public final DSLContext dslContext() {
		return this.dslContext;
	}

	public SqlUtils sqlUtils() {
		return this.sqlUtils;
	}

}
