package io.dddrive.doc.model;

import io.dddrive.ddd.model.AggregateRepository;
import io.dddrive.ddd.model.enums.CodePartListType;
import io.dddrive.ddd.model.enums.CodePartListTypeEnum;

public interface DocRepository<D extends Doc, V extends Object> extends AggregateRepository<D, V> {

	static CodePartListType transitionListType() {
		return CodePartListTypeEnum.getPartListType("doc.transitionList");
	}

	default DocPartTransitionRepository getTransitionRepository() {
		return this.getAppContext().getBean(DocPartTransitionRepository.class);
	}

	default DocPartItemRepository getItemRepository() {
		return this.getAppContext().getBean(DocPartItemRepository.class);
	}

}
