package io.dddrive.ddd;

public interface IdProvider {

	/**
	 * Provide a new Doc id
	 *
	 * @return new id
	 */
	Integer nextDocId();

	/**
	 * Check if the given id is a Doc id
	 *
	 * @param id id to check
	 * @return true if id is a Doc id
	 */
	boolean isDocId(Integer id);

	/**
	 * Provide a new DocPart id
	 *
	 * @return new id
	 */
	Integer nextDocPartId();

	/**
	 * Provide a new Obj id
	 *
	 * @return new id
	 */
	Integer nextObjId();

	/**
	 * Check if the given id is an Obj id
	 *
	 * @param id id to check
	 * @return true if id is an Obj id
	 */
	boolean isObjId(Integer id);

	/**
	 * Provide a new ObjPart id
	 *
	 * @return new id
	 */
	Integer nextObjPartId();

}
