/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.kubernetes.bindings.bundlebee.v1;

import io.yupiik.kubernetes.bindings.bundlebee.Exportable;
import io.yupiik.kubernetes.bindings.bundlebee.Validable;
import io.yupiik.kubernetes.bindings.bundlebee.v1.Alveolus;
import io.yupiik.kubernetes.bindings.bundlebee.v1.Descriptor;
import io.yupiik.kubernetes.bindings.bundlebee.v1.ManifestReference;
import io.yupiik.kubernetes.bindings.bundlebee.v1.Requirement;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Manifest
implements Validable<Manifest>,
Exportable {
    private List<Alveolus> alveoli;
    private List<ManifestReference> references;
    private List<Requirement> requirements;

    public Manifest() {
    }

    public Manifest(List<Alveolus> alveoli, List<ManifestReference> references, List<Requirement> requirements) {
        this.alveoli = alveoli;
        this.references = references;
        this.requirements = requirements;
    }

    public List<Alveolus> getAlveoli() {
        return this.alveoli;
    }

    public void setAlveoli(List<Alveolus> alveoli) {
        this.alveoli = alveoli;
    }

    public List<ManifestReference> getReferences() {
        return this.references;
    }

    public void setReferences(List<ManifestReference> references) {
        this.references = references;
    }

    public List<Requirement> getRequirements() {
        return this.requirements;
    }

    public void setRequirements(List<Requirement> requirements) {
        this.requirements = requirements;
    }

    public int hashCode() {
        return Objects.hash(this.alveoli, this.references, this.requirements);
    }

    public boolean equals(Object __other) {
        if (!(__other instanceof Manifest)) {
            return false;
        }
        Manifest __otherCasted = (Manifest)__other;
        return Objects.equals(this.alveoli, __otherCasted.alveoli) && Objects.equals(this.references, __otherCasted.references) && Objects.equals(this.requirements, __otherCasted.requirements);
    }

    public Manifest alveoli(List<Alveolus> alveoli) {
        this.alveoli = alveoli;
        return this;
    }

    public Manifest references(List<ManifestReference> references) {
        this.references = references;
        return this;
    }

    public Manifest requirements(List<Requirement> requirements) {
        this.requirements = requirements;
        return this;
    }

    @Override
    public Manifest validate() {
        return this;
    }

    @Override
    public String asJson() {
        return Stream.of(this.alveoli != null ? "\"alveoli\":" + this.alveoli.stream().map(__it -> __it == null ? "null" : __it.asJson()).collect(Collectors.joining(",", "[", "]")) : "", this.references != null ? "\"references\":" + this.references.stream().map(__it -> __it == null ? "null" : __it.asJson()).collect(Collectors.joining(",", "[", "]")) : "", this.requirements != null ? "\"requirements\":" + this.requirements.stream().map(__it -> __it == null ? "null" : __it.asJson()).collect(Collectors.joining(",", "[", "]")) : "").filter(__it -> !__it.isBlank()).collect(Collectors.joining(",", "{", "}"));
    }

    public Manifest writeTo(Path path) {
        try {
            Logger logger = Logger.getLogger(this.getClass().getName());
            Path bundlebee = Files.createDirectories(path.resolve("bundlebee"), new FileAttribute[0]);
            Path k8s = Files.createDirectories(bundlebee.resolve("kubernetes"), new FileAttribute[0]);
            Path manifestJson = bundlebee.resolve("manifest.json");
            Files.writeString(manifestJson, (CharSequence)this.asJson(), new OpenOption[0]);
            logger.info(() -> "Wrote '" + manifestJson + "'");
            if (this.alveoli != null) {
                for (Alveolus alveolus : this.alveoli) {
                    if (alveolus.getDescriptors() == null) continue;
                    for (Descriptor desc : alveolus.getDescriptors()) {
                        Path file = k8s.resolve(desc.getLocation());
                        Object underlyingDescriptor = desc.underlyingDescriptor();
                        if (underlyingDescriptor == null) continue;
                        Method asJson = underlyingDescriptor.getClass().getMethod("asJson", new Class[0]);
                        if (!asJson.canAccess(underlyingDescriptor)) {
                            asJson.setAccessible(true);
                        }
                        Files.writeString(file, (CharSequence)asJson.invoke(underlyingDescriptor, new Object[0]).toString(), new OpenOption[0]);
                        logger.info(() -> "Wrote '" + file + "'");
                    }
                }
            }
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new IllegalStateException("Invalid descriptor", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Invalid descriptor", e.getTargetException());
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
        return this;
    }
}

