/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.kubernetes.bindings.bundlebee;

public final class JsonStrings {
    private JsonStrings() {
    }

    public static String escapeJson(String text) {
        if (text.isEmpty()) {
            return "";
        }
        StringBuilder out = new StringBuilder();
        int length = text.length();
        block8: for (int i = 0; i < length; ++i) {
            int begin = i;
            int end = i;
            char c = text.charAt(i);
            while (c >= ' ' && c != '\"' && c != '\\') {
                end = ++i;
                if (i >= length) break;
                c = text.charAt(i);
            }
            if (begin < end) {
                out.append(text, begin, end);
                if (i == length) break;
            }
            switch (c) {
                case '\"': 
                case '\\': {
                    out.append('\\').append(c);
                    continue block8;
                }
                case '\b': {
                    out.append('\\').append('b');
                    continue block8;
                }
                case '\f': {
                    out.append('\\').append('f');
                    continue block8;
                }
                case '\n': {
                    out.append('\\').append('n');
                    continue block8;
                }
                case '\r': {
                    out.append('\\').append('r');
                    continue block8;
                }
                case '\t': {
                    out.append('\\').append('t');
                    continue block8;
                }
                default: {
                    String hex = "000" + Integer.toHexString(c);
                    out.append("\\u").append(hex.substring(hex.length() - 4));
                }
            }
        }
        return out.toString();
    }
}

