/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.bundlebee.documentation;

import io.yupiik.bundlebee.core.descriptor.Manifest;
import io.yupiik.bundlebee.core.lang.Substitutor;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbConfig;

public class OperatorGenerator
implements Runnable {
    private final Path sourceBase;

    public OperatorGenerator(Path sourceBase) {
        this.sourceBase = sourceBase;
    }

    @Override
    public void run() {
        try {
            Manifest.Alveolus alveolus = this.findAlveolus();
            Path root = Files.createDirectories(this.sourceBase.resolve("content/_partials/generated"), new FileAttribute[0]);
            Files.writeString(root.resolve("operator.allinone.json"), (CharSequence)this.createAllInOneYaml(alveolus), new OpenOption[0]);
            Files.writeString(root.resolve("operator.configuration.adoc"), (CharSequence)this.bundlebeePlaceholders(alveolus), new OpenOption[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private String bundlebeePlaceholders(Manifest.Alveolus alveolus) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return alveolus.getDescriptors().stream().flatMap(d -> {
            HashMap map = new HashMap();
            try (InputStream stream = this.findDescriptor(loader, (Manifest.Descriptor)d);){
                new Substitutor((k, v) -> {
                    map.put(k, v);
                    return v;
                }).replace(new String(stream.readAllBytes(), StandardCharsets.UTF_8), null);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            return map.entrySet().stream();
        }).distinct().map(e -> {
            String desc;
            String start = (String)e.getKey() + ":: ";
            String end = " Default value: `" + (String)e.getValue() + "`.";
            switch ((String)e.getKey()) {
                case "bundlebee.operator.crd.scope": {
                    desc = "scope of the operator.";
                    break;
                }
                case "bundlebee.operator.namespace": {
                    desc = "namespace of the operator.";
                    break;
                }
                case "bundlebee.operator.deployment.dryRun": {
                    desc = "is dry run mode enabled (for testing purposes).";
                    break;
                }
                case "bundlebee.operator.deployment.http.threads": {
                    desc = "how many threads are allocated to the http client.";
                    break;
                }
                case "bundlebee.operator.deployment.downloads.enabled": {
                    desc = "can the operator download alveoli or should it use the local provisionned maven repository only (kind of explicit enablement of dependencies).";
                    break;
                }
                case "bundlebee.operator.deployment.verbose": {
                    desc = "does the operator log or not the HTTP requests/responses it does (for debug purposes).";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown placeholder: '" + (String)e.getKey() + "'");
                }
            }
            return start + desc + end;
        }).collect(Collectors.joining("\n\n"));
    }

    private InputStream findDescriptor(ClassLoader loader, Manifest.Descriptor d) {
        return Objects.requireNonNull(loader.getResourceAsStream("bundlebee/kubernetes/" + d.getName()), () -> d.getName() + " not found");
    }

    private String createAllInOneYaml(Manifest.Alveolus alveolus) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return alveolus.getDescriptors().stream().map(d -> {
            String string;
            block8: {
                InputStream stream = this.findDescriptor(loader, (Manifest.Descriptor)d);
                try {
                    string = new Substitutor((k, v) -> v).replace(new String(stream.readAllBytes(), StandardCharsets.UTF_8));
                    if (stream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                }
                stream.close();
            }
            return string;
        }).collect(Collectors.joining("\n"));
    }

    private Manifest.Alveolus findAlveolus() throws Exception {
        InputStream manifest = Collections.list(Thread.currentThread().getContextClassLoader().getResources("bundlebee/manifest.json")).stream().filter(url -> {
            Path it = org.apache.xbean.finder.util.Files.toFile((URL)url).toPath();
            Path current = it;
            if (!current.getFileName().toString().endsWith(".jar")) {
                Iterator<String> unwrapped = List.of("manifest.json", "bundlebee", "classes", "target").iterator();
                while (current != null && unwrapped.hasNext() && current.getFileName().toString().equals(unwrapped.next())) {
                    current = current.getParent();
                }
            }
            return current != null && current.getFileName().toString().startsWith("bundlebee-operator");
        }).map(it -> {
            try {
                return it.openStream();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }).findFirst().orElseThrow(() -> new IllegalArgumentException("No manifest.json for bundlebee-operator"));
        try (Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().setProperty("johnzon-.skip-cdi", (Object)true));){
            Manifest mf = (Manifest)jsonb.fromJson(manifest, Manifest.class);
            if (mf.getAlveoli().size() != 1) {
                throw new IllegalArgumentException("Invalid manifest for bundlebee operator");
            }
            Manifest.Alveolus alveolus = (Manifest.Alveolus)mf.getAlveoli().iterator().next();
            return alveolus;
        }
    }
}

