/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.bundlebee.documentation;

import io.yupiik.bundlebee.core.command.Executable;
import io.yupiik.bundlebee.core.configuration.Description;
import io.yupiik.bundlebee.documentation.DocEntryFormatter;
import io.yupiik.bundlebee.documentation.FinderFactory;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.xbean.finder.AnnotationFinder;
import org.apache.xbean.finder.ClassFinder;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public class CommandConfigurationGenerator
implements Runnable {
    @Generated
    private final Logger log = Logger.getLogger(CommandConfigurationGenerator.class.getName());
    protected final Path sourceBase;
    protected final Map<String, String> configuration;

    @Override
    public void run() {
        try {
            Path output = this.sourceBase.resolve("content/commands");
            Files.createDirectories(output, new FileAttribute[0]);
            List<Map.Entry<Path, String>> docs = this.generate(output, new FinderFactory(this.configuration).finder());
            Path commandsAdoc = output.getParent().resolve("commands.adoc");
            Files.writeString(commandsAdoc, (CharSequence)("= Available commands\n:minisite-index: 300\n:minisite-index-title: Commands\n:minisite-index-description: Available commands.\n:minisite-index-icon: terminal\n\n\n" + docs.stream().sorted(Map.Entry.comparingByKey()).map(it -> {
                String filename = ((Path)it.getKey()).getFileName().toString();
                return "- xref:commands/" + filename + "[" + filename.substring(0, filename.length() - ".configuration.adoc".length()) + "]: " + Character.toLowerCase(((String)it.getValue()).charAt(0)) + ((String)it.getValue()).substring(1) + (((String)it.getValue()).endsWith(".") ? "" : ".");
            }).collect(Collectors.joining("\n")) + "\n"), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            this.log.info("Created " + String.valueOf(commandsAdoc));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private List<Map.Entry<Path, String>> generate(Path base, AnnotationFinder finder) {
        DocEntryFormatter formatter = new DocEntryFormatter();
        List sharedConfig = finder.findAnnotatedFields(ConfigProperty.class).stream().filter(it -> it.isAnnotationPresent(Description.class)).filter(it -> !it.getDeclaringClass().getName().startsWith("io.yupiik.bundlebee.core.command.")).collect(Collectors.toList());
        String sharedConfigDoc = "\n=== Inherited Global Configuration\n\nTIP: for these configurations, don't hesitate to use `~/.bundlebeerc` or `--config-file <path to config>` (just remove the `--` prefix from option keys).\n\n" + sharedConfig.stream().map(it -> formatter.format((Field)it, k -> "--" + k)).sorted().collect(Collectors.joining("\n\n")) + "\n";
        try {
            Files.writeString(base.resolve("../_partials/generated/shared.env.configuration.adoc"), (CharSequence)(sharedConfig.stream().map(it -> formatter.format((Field)it, k -> "--" + k, true)).sorted().collect(Collectors.joining("\n\n")) + "\n"), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return finder.enableFindImplementations().findImplementations(Executable.class).stream().filter(it -> !Modifier.isAbstract(it.getModifiers()) && !it.isInterface()).map(command -> {
            try {
                Executable instance = command.asSubclass(Executable.class).getConstructor(new Class[0]).newInstance(new Object[0]);
                String name = instance.name();
                Pattern prefix = Pattern.compile("^bundlebee\\." + name + "\\.");
                String config = new ClassFinder(new Class[]{command}).findAnnotatedFields(ConfigProperty.class).stream().map(it -> formatter.format((Field)it, k -> "--" + prefix.matcher((CharSequence)k).replaceAll(""))).sorted().collect(Collectors.joining("\n\n"));
                Path conf = base.resolve(name + ".configuration.adoc");
                String description = instance.description();
                Files.writeString(conf, (CharSequence)("= " + Character.toUpperCase(name.charAt(0)) + name.substring(1) + "\n\nName: `" + name + "`.\n\n" + description + "\n\n== Configuration\n\n" + (config.isEmpty() ? "No configuration." : config) + "\n" + (this.skipSharedConfig(name) ? "" : sharedConfigDoc)), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                this.log.info("Created " + String.valueOf(conf));
                int end = description.indexOf("\n//");
                return Map.entry(conf, end > 0 ? description.substring(0, end) : description);
            }
            catch (IOException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
        }).collect(Collectors.toList());
    }

    private boolean skipSharedConfig(String name) {
        return "add-alveolus".equals(name) || "list-alveoli".equals(name) || "list-lint-rules".equals(name) || "cipher".equals(name) || "decipher".equals(name) || "build".equals(name) || "cipher-password".equals(name) || "create-master-password".equals(name) || "new".equals(name) || "version".equals(name);
    }

    @Generated
    public CommandConfigurationGenerator(Path sourceBase, Map<String, String> configuration) {
        this.sourceBase = sourceBase;
        this.configuration = configuration;
    }
}

