/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.bundlebee.documentation;

import io.yupiik.bundlebee.core.descriptor.Manifest;
import io.yupiik.bundlebee.core.lang.Substitutor;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbConfig;
import lombok.Generated;
import org.yaml.snakeyaml.Yaml;

public class AlveoliConfigurationGenerator
implements Runnable {
    @Generated
    private final Logger log = Logger.getLogger(AlveoliConfigurationGenerator.class.getName());
    protected final Path sourceBase;
    protected final Map<String, String> configuration;

    @Override
    public void run() {
        Yaml yaml = new Yaml();
        try (Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().setProperty("johnzon-.skip-cdi", (Object)true));){
            Path output = this.sourceBase.resolve("content/alveoli");
            Files.createDirectories(output, new FileAttribute[0]);
            Path alveoliRoot = this.sourceBase.getParent().getParent().getParent().getParent().resolve("alveolus");
            List<String> docs = this.generateAndReturnLinks(output, alveoliRoot, jsonb, yaml);
            Path commandsAdoc = output.getParent().resolve("alveoli.adoc");
            Files.writeString(commandsAdoc, (CharSequence)("= Available Alveoli\n:minisite-index: 400\n:minisite-index-title: Alveoli\n:minisite-index-description: Available alveoli/recipes/deployments.\n:minisite-index-icon: puzzle-piece\n\n\n" + docs.stream().sorted().map(it -> "- " + it).collect(Collectors.joining("\n\n")) + "\n"), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            this.log.info("Created " + String.valueOf(commandsAdoc));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private List<String> generateAndReturnLinks(final Path base, Path alveolusRoot, final Jsonb jsonb, final Yaml yaml) {
        final ArrayList<String> links = new ArrayList<String>();
        try {
            Files.walkFileTree(alveolusRoot, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    Path manifest = dir.resolve("target/classes/bundlebee/manifest.json");
                    if (Files.exists(manifest, new LinkOption[0])) {
                        links.addAll(AlveoliConfigurationGenerator.this.generateAlveolusDoc(dir.getFileName().toString(), manifest, jsonb, yaml, base));
                    }
                    if (!Files.exists(dir.resolve("pom.xml"), new LinkOption[0])) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return links;
    }

    private List<String> generateAlveolusDoc(String artifactId, Path manifest, Jsonb jsonb, Yaml yaml, Path alveoliOutputBase) {
        try {
            String mfString = Files.readString(manifest, StandardCharsets.UTF_8);
            JsonObject json = (JsonObject)jsonb.fromJson(mfString, JsonObject.class);
            Manifest mf = (Manifest)jsonb.fromJson(mfString, Manifest.class);
            return mf.getAlveoli().stream().map(it -> {
                String fileName = artifactId + "-" + it.getName().replaceAll(":([0-9]+\\.[0-9]+\\.[0-9]+(-SNAPSHOT)?)$", "").replaceAll("[^a-zA-Z0-9\\-_]", "-") + ".adoc";
                Path target = alveoliOutputBase.resolve(fileName);
                JsonObject rawAlveolusSpec = json.getJsonArray("alveoli").stream().map(JsonValue::asJsonObject).filter(item -> Objects.equals(it.getName(), item.getString("name"))).findFirst().orElseThrow();
                String description = rawAlveolusSpec.containsKey((Object)"//") ? rawAlveolusSpec.getString("//").trim() + "\n" : "";
                try {
                    Files.writeString(target, (CharSequence)this.toAlveolusDoc((Manifest.Alveolus)it, manifest.getParent(), rawAlveolusSpec, artifactId, description, jsonb, yaml), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
                this.log.info("Created " + String.valueOf(target));
                String desc = this.extractShortDescription(Character.toLowerCase(description.charAt(0)) + description.substring(1).trim());
                return "*" + artifactId + "* (xref:alveoli/" + fileName + "[" + it.getName() + "]): " + this.addDotIfNeeded(desc);
            }).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private String extractShortDescription(String s) {
        int end = s.indexOf("\n//");
        return end > 0 ? s.substring(0, end) : s;
    }

    private String addDotIfNeeded(String desc) {
        return desc + (desc.endsWith(".") ? "" : ".");
    }

    private String toAlveolusDoc(Manifest.Alveolus alveolus, Path bundleBeeFolder, JsonObject rawAlveolusSpec, String artifactId, String description, Jsonb jsonb, Yaml yaml) {
        List<Placeholder> placeholders = this.findPlaceholders(bundleBeeFolder, alveolus, rawAlveolusSpec.containsKey((Object)"placeholdersDoc") ? rawAlveolusSpec.getJsonArray("placeholdersDoc").stream().map(JsonValue::asJsonObject).collect(Collectors.toMap(o -> o.getString("name"), Function.identity())) : Map.of());
        placeholders.forEach(p -> {
            if (!p.getName().startsWith(artifactId)) {
                throw new IllegalArgumentException("Built-in alveolus must use the artifactId as placeholder prefix (naming convention). " + String.valueOf(p) + " does not respect that (" + artifactId + " expected).");
            }
        });
        String dependencies = Optional.ofNullable((JsonValue)rawAlveolusSpec.get((Object)"dependencies")).map(JsonValue::asJsonArray).map(deps -> "== Dependencies\n\n" + deps.stream().map(JsonValue::asJsonObject).map(dep -> "* `" + dep.getString("name") + "` from `" + dep.getString("location") + "` dependency").collect(Collectors.joining("\n", "", "\n"))).orElse("");
        return "= " + alveolus.getName() + "\n\n" + description + "\n== Maven Dependency\n\n[source,xml]\n----\n<dependency>\n  <groupId>io.yupiik.alveoli</groupId>\n  <artifactId>" + artifactId + "</artifactId>\n  <version>" + this.configuration.get("version") + "</version>\n</dependency>\n----\n\n" + this.addDefaultConfigurationDocIfAny(bundleBeeFolder, alveolus, jsonb, yaml) + this.addPortsDocIfAny(bundleBeeFolder, alveolus, jsonb, yaml) + "== Sample Usage\n\n[source,json]\n----\n{\n  \"alveoli\": [\n    {\n      \"//\": \"My alveolus.\",\n      \"name\": \"com.company:my-app:1.0.0\",\n      \"descriptors\": [],\n      \"dependencies\": [\n        {\n          \"name\": \"" + alveolus.getName() + "\",\n          \"location\": \"io.yupiik.alveoli:" + artifactId + ":" + this.configuration.get("version") + "\",\n        }\n      ]" + (placeholders.isEmpty() ? "" : ",") + "\n" + (String)(placeholders.isEmpty() ? "" : "      \"patches\": [{\n        \"descriptorName\": \"" + alveolus.getName() + "\",\n        \"interpolate\": true\n      }]\n") + "    }\n  ]\n}\n----\n\n" + dependencies + (String)(placeholders.isEmpty() ? "" : "== Configuration\n\n" + placeholders.stream().map(it -> it.getName() + "::\n" + it.getDescription() + "\n" + Optional.of(it.getDefaultValue()).filter(v -> !"org.eclipse.microprofile.config.configproperty.unconfigureddvalue".equals(v)).map(v -> "Default value: `" + v + "`.").orElse("No default value.")).collect(Collectors.joining("\n\n", "", "\n")));
    }

    private String addDefaultConfigurationDocIfAny(Path bundleBeeFolder, Manifest.Alveolus alveolus, Jsonb jsonb, Yaml yaml) {
        String configs = Optional.ofNullable(alveolus.getDescriptors()).stream().flatMap(Collection::stream).filter(it -> it.getName().endsWith("configmap")).map(desc -> this.toJson(bundleBeeFolder, jsonb, yaml, (Manifest.Descriptor)desc)).filter(desc -> "ConfigMap".equals(desc.getString("kind")) && desc.containsKey((Object)"data")).sorted(Comparator.comparing(desc -> desc.getJsonObject("metadata").getString("name"))).map(desc -> desc.getJsonObject("data")).map(data -> data.entrySet().stream().map(e -> new AbstractMap.SimpleImmutableEntry<String, String>((String)e.getKey(), this.toString((JsonValue)e.getValue()))).map(e -> (String)e.getKey() + "::\n" + (((String)e.getValue()).contains("\n") ? "[source]\n----\n" + (String)e.getValue() + "\n----\n" : "`" + (String)e.getValue() + "`")).collect(Collectors.joining("\n", "", "\n\n"))).collect(Collectors.joining("\n"));
        return configs.isBlank() ? "" : "== Default Configuration\n\n" + configs;
    }

    private String addPortsDocIfAny(Path bundleBeeFolder, Manifest.Alveolus alveolus, Jsonb jsonb, Yaml yaml) {
        String content = Optional.ofNullable(alveolus.getDescriptors()).stream().flatMap(Collection::stream).filter(it -> it.getName().endsWith("service")).map(desc -> this.toJson(bundleBeeFolder, jsonb, yaml, (Manifest.Descriptor)desc)).filter(desc -> "Service".equals(desc.getString("kind")) && "NodePort".equals(desc.getJsonObject("spec").getString("type")) && desc.getJsonObject("spec").containsKey((Object)"ports")).sorted(Comparator.comparing(desc -> desc.getJsonObject("metadata").getString("name"))).map(desc -> {
            JsonArray ports = desc.getJsonObject("spec").getJsonArray("ports");
            String name = desc.getJsonObject("metadata").getString("name");
            return ports.stream().map(JsonValue::asJsonObject).map(port -> "* Name: `" + (String)(port.containsKey((Object)"name") ? name + " (" + this.toString((JsonValue)port.get((Object)"name")) + ")" : name) + "`\n" + (String)(port.containsKey((Object)"protocol") ? "** Protocol: " + port.getString("protocol") + "\n" : "") + (String)(port.containsKey((Object)"port") ? "** Port: " + this.toString((JsonValue)port.get((Object)"port")) + "\n" : "") + (String)(port.containsKey((Object)"targetPort") ? "** Target Port: " + this.toString((JsonValue)port.get((Object)"targetPort")) + "\n" : "") + (String)(port.containsKey((Object)"nodePort") ? "** Node Port: " + this.toString((JsonValue)port.get((Object)"nodePort")) + "\n" : "")).collect(Collectors.joining("\n", "", (CharSequence)(ports.stream().anyMatch(it -> it.asJsonObject().containsKey((Object)"nodePort")) ? "\nTIP: on linux and with minikube you can access this service using `http://$(minikube ip):" + ports.stream().filter(it -> it.asJsonObject().containsKey((Object)"nodePort")).findFirst().map(it -> this.toString((JsonValue)it.asJsonObject().get((Object)"nodePort"))).orElseThrow() + "` on your host.\n\n" : "\n")));
        }).collect(Collectors.joining("\n"));
        return content.isBlank() ? "" : "== Ports\n\n" + content;
    }

    private JsonObject toJson(Path bundleBeeFolder, Jsonb jsonb, Yaml yaml, Manifest.Descriptor desc) {
        try {
            return (JsonObject)jsonb.fromJson(jsonb.toJson(yaml.load(Files.readString(bundleBeeFolder.resolve(desc.getType()).resolve(desc.getName() + ".yaml")))), JsonObject.class);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private String toString(JsonValue json) {
        if (json.getValueType() == JsonValue.ValueType.STRING) {
            return ((JsonString)JsonString.class.cast(json)).getString();
        }
        return json.toString();
    }

    private List<Placeholder> findPlaceholders(Path bundleBeeFolder, Manifest.Alveolus alveolus, Map<String, JsonObject> placeholderDocs) {
        return alveolus.getDescriptors().stream().flatMap(desc -> {
            try {
                Path file = Files.list(bundleBeeFolder.resolve(desc.getType())).filter(it -> {
                    String name = it.getFileName().toString();
                    return Objects.equals(name, desc.getName()) || Objects.equals(name, desc.getName() + ".yaml") || Objects.equals(name, desc.getName() + ".yml") || Objects.equals(name, desc.getName() + ".json");
                }).findFirst().orElseThrow(() -> new IllegalArgumentException("No descriptor " + String.valueOf(desc) + " found"));
                HashSet placeholders = new HashSet();
                new Substitutor((key, defVal) -> {
                    if (key.startsWith("bundlebee-")) {
                        return "";
                    }
                    placeholders.add(new Placeholder((String)key, Optional.ofNullable(defVal).orElse("org.eclipse.microprofile.config.configproperty.unconfigureddvalue"), Optional.ofNullable((JsonObject)placeholderDocs.get(key)).orElseThrow(() -> new IllegalArgumentException("Missing\n\n\"placeholdersDoc\": [\n        {\n          \"name\": \"" + key + "\",\n          \"description\": \"....\"\n        }\n      ]\n\nin " + String.valueOf(alveolus))).getString("description")));
                    return "";
                }).replace(Files.readString(file, StandardCharsets.UTF_8), null);
                return placeholders.stream();
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }).distinct().sorted(Comparator.comparing(Placeholder::getName)).collect(Collectors.toList());
    }

    @Generated
    public AlveoliConfigurationGenerator(Path sourceBase, Map<String, String> configuration) {
        this.sourceBase = sourceBase;
        this.configuration = configuration;
    }

    private static class Placeholder {
        private final String name;
        private final String defaultValue;
        private final String description;

        @Generated
        public Placeholder(String name, String defaultValue, String description) {
            this.name = name;
            this.defaultValue = defaultValue;
            this.description = description;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getDefaultValue() {
            return this.defaultValue;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Placeholder)) {
                return false;
            }
            Placeholder other = (Placeholder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$defaultValue = this.getDefaultValue();
            String other$defaultValue = other.getDefaultValue();
            if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            return !(this$description == null ? other$description != null : !this$description.equals(other$description));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Placeholder;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $defaultValue = this.getDefaultValue();
            result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AlveoliConfigurationGenerator.Placeholder(name=" + this.getName() + ", defaultValue=" + this.getDefaultValue() + ", description=" + this.getDescription() + ")";
        }
    }
}

