/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.bundlebee.documentation;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;

public class K8sJSONSchemasGenerator
implements Runnable {
    private final Logger log = Logger.getLogger(K8sJSONSchemasGenerator.class.getName());
    private final Pattern versionSplitter = Pattern.compile("\\.");
    private final Path sourceBase;
    private final String tagsUrl;
    private final String urlTemplate;
    private final boolean force;
    private final int maxThreads;
    private final Function<HttpRequest.Builder, HttpRequest.Builder> setAuth;
    private final boolean skip;
    private final int[] minVersion;
    private final Path cache;

    public K8sJSONSchemasGenerator(Path sourceBase, Map<String, String> configuration) {
        this.skip = !Boolean.parseBoolean(configuration.getOrDefault("minisite.actions.k8s.jsonschema", "false"));
        this.sourceBase = sourceBase;
        this.tagsUrl = Objects.requireNonNull(configuration.get("tagsUrl"), () -> "No tagsUrl in " + configuration);
        this.urlTemplate = Objects.requireNonNull(configuration.get("specUrlTemplate"), () -> "No specUrlTemplate in " + configuration);
        this.force = Boolean.parseBoolean(configuration.get("force"));
        this.maxThreads = Integer.parseInt(configuration.get("maxThreads"));
        this.minVersion = this.parseVersion(configuration.get("minVersion"));
        try {
            this.cache = Files.createDirectories(sourceBase.resolve("content/_partials/generated/jsonschema/generated/cache"), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        String token = configuration.get("githubToken");
        this.setAuth = token != null && !token.isBlank() ? b -> b.header("Authorization", "Bearer " + token) : Function.identity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.skip) {
            Logger.getLogger(this.getClass().getName()).info(() -> "Skipping " + this.getClass().getSimpleName());
            return;
        }
        HttpClient httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).build();
        JsonReaderFactory jsonReaderFactory = Json.createReaderFactory(Map.of());
        JsonBuilderFactory jsonBuilderFactory = Json.createBuilderFactory(Map.of());
        JsonWriterFactory jsonWriterFactory = Json.createWriterFactory(Map.of("javax.json.stream.JsonGenerator.prettyPrinting", true));
        int concurrency = Math.max(this.maxThreads, Math.min(4, Math.max(1, Runtime.getRuntime().availableProcessors())));
        ExecutorService tasks = Executors.newFixedThreadPool(concurrency, new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, this.getClass().getName() + "-" + this.counter.incrementAndGet());
            }
        });
        this.log.info(() -> "Using " + concurrency + " threads");
        IllegalStateException errorCapture = new IllegalStateException("An error occurred during generation");
        CopyOnWriteArrayList awaited = new CopyOnWriteArrayList();
        try {
            Path root = Files.createDirectories(this.sourceBase.resolve("assets/generated/kubernetes/jsonschema"), new FileAttribute[0]);
            for (String version : this.fetchTags(httpClient, this.tagsUrl, jsonReaderFactory)) {
                if (version.startsWith("1.4.") || version.startsWith("1.3.") || version.startsWith("1.2.") || version.startsWith("1.1.") || version.startsWith("1.0.") || version.startsWith("v0.")) {
                    this.log.fine(() -> "Skipping version without an openapi: " + version);
                    continue;
                }
                int[] pVersion = this.parseVersion(version);
                boolean skipVersion = false;
                for (int i = 0; i < pVersion.length && i < this.minVersion.length; ++i) {
                    if (pVersion[i] >= this.minVersion[i]) continue;
                    skipVersion = true;
                    break;
                }
                if (skipVersion) {
                    this.log.fine(() -> "Skipping version (<minVersion): " + version);
                    continue;
                }
                String url = this.urlTemplate.replace("{{version}}", version);
                awaited.add(tasks.submit(() -> {
                    IllegalStateException illegalStateException = errorCapture;
                    synchronized (illegalStateException) {
                        if (errorCapture.getSuppressed().length > 0) {
                            this.log.warning(() -> "Cancelling task '" + url + "' since there is(are) error(s).");
                            return;
                        }
                    }
                    try {
                        this.generate(Files.createDirectories(root.resolve(version), new FileAttribute[0]), url, httpClient, jsonBuilderFactory, jsonReaderFactory, jsonWriterFactory, version);
                    }
                    catch (IOException | RuntimeException ioe) {
                        this.log.log(Level.SEVERE, ioe, ioe::getMessage);
                        IllegalStateException illegalStateException2 = errorCapture;
                        synchronized (illegalStateException2) {
                            errorCapture.addSuppressed(ioe);
                        }
                        throw new IllegalStateException(ioe);
                    }
                    catch (InterruptedException e) {
                        this.log.log(Level.SEVERE, e, e::getMessage);
                        IllegalStateException illegalStateException3 = errorCapture;
                        synchronized (illegalStateException3) {
                            errorCapture.addSuppressed(e);
                        }
                        Thread.currentThread().interrupt();
                    }
                }));
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
        catch (InterruptedException e2) {
            Thread.currentThread().interrupt();
        }
        finally {
            tasks.shutdown();
            try {
                for (Future future : awaited) {
                    try {
                        future.get();
                    }
                    catch (ExecutionException e3) {
                        this.log.log(Level.SEVERE, e3, e3::getMessage);
                        IllegalStateException illegalStateException = errorCapture;
                        synchronized (illegalStateException) {
                            errorCapture.addSuppressed(e3);
                        }
                    }
                }
                if (!tasks.awaitTermination(1L, TimeUnit.MINUTES)) {
                    this.log.warning(() -> "Wrong interruption of generation task");
                }
            }
            catch (InterruptedException e4) {
                Thread.currentThread().interrupt();
            }
        }
        if (errorCapture.getSuppressed().length > 0) {
            throw new IllegalStateException(Stream.of(errorCapture.getSuppressed()).map(e -> {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try (PrintStream ps = new PrintStream(out);){
                    e.printStackTrace(ps);
                }
                return out.toString(StandardCharsets.UTF_8);
            }).collect(Collectors.joining("\n- ", "\n- ", "")));
        }
    }

    private int[] parseVersion(String version) {
        int sep = version.indexOf(45);
        if (sep > 0) {
            return this.parseVersion(version.substring(0, sep));
        }
        if (version.startsWith("v")) {
            return this.parseVersion(version.substring(1));
        }
        return Stream.of(this.versionSplitter.split(version)).mapToInt(Integer::parseInt).toArray();
    }

    private Iterable<String> fetchTags(final HttpClient httpClient, final String uri, final JsonReaderFactory jsonReaderFactory) throws IOException, InterruptedException {
        return () -> new Iterator<String>(){
            private URI next;
            private Iterator delegate;
            {
                this.next = URI.create(uri + "?per_page=100");
            }

            @Override
            public boolean hasNext() {
                if (this.delegate != null && this.delegate.hasNext()) {
                    return true;
                }
                if (this.next == null) {
                    return false;
                }
                return this.doHasNext(3);
            }

            private boolean doHasNext(int retries) {
                try {
                    JsonArray array;
                    K8sJSONSchemasGenerator.this.log.info(() -> "Fetching " + this.next);
                    HttpResponse<String> response = httpClient.send(K8sJSONSchemasGenerator.this.setAuth.apply(HttpRequest.newBuilder().GET().uri(this.next).version(HttpClient.Version.HTTP_1_1).header("accept", "application/json")).build(), HttpResponse.BodyHandlers.ofString());
                    switch (response.statusCode()) {
                        case 200: {
                            break;
                        }
                        case 503: {
                            if (retries > 0) {
                                Thread.sleep(5000L);
                                return this.doHasNext(retries - 1);
                            }
                            throw new IllegalStateException("Invalid response: " + response + ": " + response.body());
                        }
                        case 403: {
                            ZonedDateTime reset = K8sJSONSchemasGenerator.this.rateLimitReset(response);
                            if (reset != null) {
                                Thread.sleep(Math.max(1L, Duration.between(OffsetDateTime.now(), reset).toMillis()));
                            }
                            K8sJSONSchemasGenerator.this.log.warning(() -> "Rate limit hit, skipping for this run: " + response + "\nX-RateLimit-Limit=" + response.headers().firstValue("X-RateLimit-Limit").orElse("?") + "\nX-RateLimit-Reset=" + reset);
                            return false;
                        }
                        default: {
                            throw new IllegalStateException("Invalid response: " + response + ": " + response.body());
                        }
                    }
                    try (JsonReader reader = jsonReaderFactory.createReader((Reader)new StringReader(response.body()));){
                        array = reader.readArray();
                    }
                    this.next = response.headers().allValues("link").stream().flatMap(it -> Stream.of(it.split(","))).map(String::strip).filter(it -> it.endsWith("rel=\"next\"")).findFirst().map(it -> URI.create(it.substring(it.indexOf("<") + 1, it.indexOf(">")))).orElse(null);
                    this.delegate = array.stream().map(JsonValue::asJsonObject).map(i -> i.getString("name")).filter(it -> !it.contains("-alpha.") && !it.contains("-beta.") && !it.contains("-rc.")).iterator();
                    if (!this.delegate.hasNext()) {
                        return this.hasNext();
                    }
                    return true;
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return false;
                }
            }

            @Override
            public String next() {
                return (String)this.delegate.next();
            }
        };
    }

    private ZonedDateTime rateLimitReset(HttpResponse<?> response) {
        return response.headers().firstValue("X-RateLimit-Reset").map(Long::parseLong).map(Instant::ofEpochSecond).map(i -> i.atZone(ZoneOffset.systemDefault())).map(i -> {
            this.log.info(() -> "Rate limit reset: " + i);
            return i;
        }).orElse(null);
    }

    private void generate(Path root, String url, HttpClient httpClient, JsonBuilderFactory jsonBuilderFactory, JsonReaderFactory jsonReaderFactory, JsonWriterFactory jsonWriterFactory, String versionName) throws IOException, InterruptedException {
        JsonObject spec;
        this.log.info(() -> "Fetching '" + url + "'");
        Path cached = this.cache.resolve(versionName.replace('/', '_') + ".json");
        if (Files.notExists(cached, new LinkOption[0])) {
            HttpResponse response = this.retry(5, () -> {
                Thread thread = Thread.currentThread();
                String oldName = thread.getName();
                thread.setName(oldName + "[" + url + "]");
                try {
                    HttpResponse<InputStream> httpResponse = httpClient.send(this.setAuth.apply(HttpRequest.newBuilder().GET().uri(URI.create(url)).header("accept-encoding", "gzip").version(HttpClient.Version.HTTP_1_1)).build(), HttpResponse.BodyHandlers.ofInputStream());
                    return httpResponse;
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IllegalStateException(e);
                }
                finally {
                    thread.setName(oldName);
                }
            });
            switch (response.statusCode()) {
                case 200: {
                    break;
                }
                case 404: {
                    this.log.info(() -> "No spec for '" + url + "'");
                    return;
                }
                case 403: {
                    ZonedDateTime reset = this.rateLimitReset(response);
                    if (reset != null) {
                        Thread.sleep(Math.max(1L, Duration.between(OffsetDateTime.now(), reset).toMillis()));
                    }
                    throw new IllegalStateException("Rate limited response: " + response);
                }
                default: {
                    InputStream r = (InputStream)response.body();
                    try {
                        throw new IllegalStateException("Invalid response: " + response + ": " + new String(r.readAllBytes(), StandardCharsets.UTF_8) + "\n" + response.headers().map());
                    }
                    catch (Throwable throwable) {
                        if (r != null) {
                            try {
                                r.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                }
            }
            try (JsonReader reader = jsonReaderFactory.createReader(response.headers().firstValue("content-encoding").map(it -> it.contains("gzip")).orElse(false) != false ? new GZIPInputStream((InputStream)response.body()) : (InputStream)response.body());){
                spec = reader.readObject();
            }
            Files.writeString(cached, (CharSequence)spec.toString(), new OpenOption[0]);
        } else {
            try (JsonReader reader = jsonReaderFactory.createReader((Reader)Files.newBufferedReader(cached));){
                spec = reader.readObject();
            }
            catch (RuntimeException e) {
                Files.deleteIfExists(cached);
                throw e;
            }
        }
        Map<String, JsonObject> definitions = spec.getJsonObject("definitions").entrySet().stream().filter(it -> ((JsonValue)it.getValue()).getValueType() == JsonValue.ValueType.OBJECT).collect(Collectors.toMap(Map.Entry::getKey, it -> ((JsonValue)it.getValue()).asJsonObject()));
        for (Map.Entry<String, JsonObject> definition : definitions.entrySet()) {
            JsonObject obj = definition.getValue().asJsonObject();
            JsonValue meta = (JsonValue)obj.get((Object)"x-kubernetes-group-version-kind");
            if (meta == null || meta.getValueType() != JsonValue.ValueType.ARRAY) continue;
            for (JsonValue entry : meta.asJsonArray()) {
                JsonObject currentMeta = entry.asJsonObject();
                if (!currentMeta.containsKey((Object)"kind") || !currentMeta.containsKey((Object)"version")) continue;
                String version = currentMeta.getString("version");
                String kind = currentMeta.getString("kind");
                String filename = kind + ".jsonschema.json";
                Path versionned = Files.createDirectories(root.resolve(version), new FileAttribute[0]).resolve(filename);
                Path raw = versionned.getParent().resolve(kind + ".jsonschema.raw.json");
                Path versionless = root.resolve(filename);
                String jsonString = null;
                if (this.force || !Files.exists(versionned, new LinkOption[0])) {
                    jsonString = this.doResolve(jsonBuilderFactory, jsonWriterFactory, definitions, obj);
                    Files.writeString(versionned, (CharSequence)jsonString, new OpenOption[0]);
                    this.log.info(() -> "Wrote '" + versionned + "'");
                }
                if (this.force || !Files.exists(raw, new LinkOption[0])) {
                    Files.writeString(raw, (CharSequence)K8sJSONSchemasGenerator.toString(jsonWriterFactory, obj), new OpenOption[0]);
                    this.log.info(() -> "Wrote '" + raw + "'");
                }
                if (!this.force && Files.exists(versionless, new LinkOption[0])) continue;
                if (jsonString == null) {
                    jsonString = this.doResolve(jsonBuilderFactory, jsonWriterFactory, definitions, obj);
                }
                Files.writeString(versionless, (CharSequence)jsonString, new OpenOption[0]);
                this.log.info(() -> "Wrote '" + versionless + "'");
            }
        }
    }

    private <T> T retry(int max, Supplier<T> supplier) {
        for (int i = 0; i < max; ++i) {
            try {
                return supplier.get();
            }
            catch (RuntimeException ie) {
                if (i == max - 1) {
                    throw ie;
                }
                this.log.warning("An error occurred, step will be retried (" + ie.getMessage() + ")");
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IllegalStateException(e);
                }
            }
        }
        throw new IllegalStateException("unlikely");
    }

    private String doResolve(JsonBuilderFactory jsonBuilderFactory, JsonWriterFactory jsonWriterFactory, Map<String, JsonObject> definitions, JsonObject obj) {
        JsonObject resolved = this.resolveRefs(jsonBuilderFactory, definitions, obj).build();
        String jsonString = K8sJSONSchemasGenerator.toString(jsonWriterFactory, resolved);
        if (jsonString.contains("$ref")) {
            throw new IllegalStateException("$ref should have been replaced: " + jsonString);
        }
        return jsonString;
    }

    private static String toString(JsonWriterFactory jsonWriterFactory, JsonObject resolved) {
        StringWriter out = new StringWriter();
        try (JsonWriter writer = jsonWriterFactory.createWriter((Writer)out);){
            writer.write((JsonStructure)resolved);
        }
        return out.toString();
    }

    private JsonObjectBuilder resolveRefs(JsonBuilderFactory jsonBuilderFactory, Map<String, JsonObject> definitions, JsonObject root) {
        JsonObjectBuilder current = jsonBuilderFactory.createObjectBuilder();
        block5: for (Map.Entry entry : root.entrySet()) {
            switch (((JsonValue)entry.getValue()).getValueType()) {
                case OBJECT: {
                    current.add((String)entry.getKey(), this.resolveRefs(jsonBuilderFactory, definitions, ((JsonValue)entry.getValue()).asJsonObject()));
                    continue block5;
                }
                case ARRAY: {
                    current.add((String)entry.getKey(), (JsonValue)jsonBuilderFactory.createArrayBuilder((Collection)((JsonValue)entry.getValue()).asJsonArray().stream().map(it -> it.getValueType() == JsonValue.ValueType.OBJECT ? this.resolveRefs(jsonBuilderFactory, definitions, it.asJsonObject()).build() : it).collect(Collectors.toList())).build());
                    continue block5;
                }
                case STRING: {
                    if ("$ref".equals(entry.getKey())) {
                        String ref = ((JsonString)JsonString.class.cast(entry.getValue())).getString();
                        JsonObjectBuilder schema = this.resolveRefs(jsonBuilderFactory, definitions, this.resolveRef(definitions, ref, jsonBuilderFactory));
                        current.addAll(schema);
                        continue block5;
                    }
                    if (((String)entry.getKey()).startsWith("x-")) continue block5;
                    current.add((String)entry.getKey(), (JsonValue)entry.getValue());
                    continue block5;
                }
            }
            current.add((String)entry.getKey(), (JsonValue)entry.getValue());
        }
        return current;
    }

    private JsonObject resolveRef(Map<String, JsonObject> definitions, String ref, JsonBuilderFactory jsonBuilderFactory) {
        if (!ref.startsWith("#/definitions/")) {
            throw new IllegalArgumentException("Wrong ref: '" + ref + "'");
        }
        String key = ref.substring("#/definitions/".length());
        if (key.substring(key.lastIndexOf(46) + 1).startsWith("JSON")) {
            return jsonBuilderFactory.createObjectBuilder().add("type", "object").build();
        }
        return Objects.requireNonNull(definitions.get(key), () -> "Didn't find ref '" + ref + "'");
    }
}

