/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.bundlebee.documentation;

import io.yupiik.bundlebee.core.command.impl.lint.LintingCheck;
import io.yupiik.bundlebee.core.command.impl.lint.builtin.NoLatestImage;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.inject.se.SeContainer;
import javax.enterprise.inject.se.SeContainerInitializer;
import org.apache.webbeans.service.DefaultLoaderService;
import org.apache.webbeans.spi.LoaderService;

public class ListChecks
implements Runnable {
    private final Path sourceBase;

    public ListChecks(Path sourceBase) {
        this.sourceBase = sourceBase;
    }

    @Override
    public void run() {
        try (SeContainer container = SeContainerInitializer.newInstance().disableDiscovery().addProperty(LoaderService.class.getName(), (Object)new DefaultLoaderService(){

            public <T> List<T> load(Class<T> aClass, ClassLoader classLoader) {
                return List.of();
            }
        }).addPackages(new Class[]{NoLatestImage.class}).initialize();){
            List checks = container.select(LintingCheck.class, new Annotation[0]).stream().collect(Collectors.toList());
            Path output = Files.createDirectories(this.sourceBase.resolve("content/_partials/generated/documentation"), new FileAttribute[0]).resolve("lint.checks.adoc");
            Files.writeString(output, (CharSequence)("= Linting Checks\n\nHere is the list of available checks by defaults.\n\n" + checks.stream().map(c -> "== " + c.name() + "\n\nName: *" + c.name() + "*.\n\n" + c.description() + "\n\n=== Remediation\n\n" + c.remediation() + "\n\n").sorted().collect(Collectors.joining("\n", "", "\n"))), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

