/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.bundlebee.documentation;

import io.yupiik.bundlebee.documentation.DocEntryFormatter;
import io.yupiik.bundlebee.documentation.FinderFactory;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.xbean.finder.IAnnotationFinder;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public class ConfigurationGenerator
implements Runnable {
    private final Logger log = Logger.getLogger(ConfigurationGenerator.class.getName());
    protected final Path sourceBase;
    protected final Map<String, String> configuration;

    @Override
    public void run() {
        String module = this.configuration.get("module");
        String exclude = this.configuration.get("exclude");
        try {
            String lines = this.generate(exclude, (IAnnotationFinder)new FinderFactory(this.configuration).finder());
            Path output = this.sourceBase.resolve("content/_partials/generated/documentation").resolve(module.replace(".*", "") + ".adoc");
            Files.createDirectories(output.getParent(), new FileAttribute[0]);
            Files.writeString(output, (CharSequence)(lines.isEmpty() ? "No configuration yet." : lines), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            this.log.info("Created " + output);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private String generate(String exclude, IAnnotationFinder finder) {
        DocEntryFormatter formatter = new DocEntryFormatter();
        return finder.findAnnotatedFields(ConfigProperty.class).stream().filter(it -> exclude == null || !it.getDeclaringClass().getName().startsWith(exclude)).map(it -> formatter.format((Field)it, Function.identity())).sorted().collect(Collectors.joining("\n\n"));
    }

    public ConfigurationGenerator(Path sourceBase, Map<String, String> configuration) {
        this.sourceBase = sourceBase;
        this.configuration = configuration;
    }
}

