/*
 * Decompiled with CFR 0.152.
 */
package io.yupiik.bundlebee.documentation;

import io.yupiik.bundlebee.core.configuration.Description;
import java.lang.reflect.Field;
import java.util.Locale;
import java.util.function.Function;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public class DocEntryFormatter {
    public String format(Field it, Function<String, String> nameMapper) {
        ConfigProperty annotation = it.getAnnotation(ConfigProperty.class);
        Description description = it.getAnnotation(Description.class);
        if (description == null) {
            throw new IllegalArgumentException("No @Description on " + it);
        }
        String desc = description.value();
        Object key = annotation.name();
        if (((String)key).isEmpty()) {
            key = it.getDeclaringClass().getName() + "." + it.getName();
        }
        String defaultValue = annotation.defaultValue();
        return nameMapper.apply((String)key) + " (`" + ((String)key).replaceAll("[^A-Za-z0-9]", "_").toUpperCase(Locale.ROOT) + "`)::\n" + (String)(desc.endsWith(".") ? desc : desc + ".") + (String)(!"org.eclipse.microprofile.config.configproperty.unconfigureddvalue".equals(defaultValue) && !"<unset>".equals(defaultValue) ? " Default value: " + (!defaultValue.contains("\n") ? "`" + defaultValue + "`" : "\n[source]\n----\n" + defaultValue + "\n----") : "");
    }
}

